/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.OnEventModelSynchronizer;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;

public class OnEventModelSyncronizerTest
extends MockObjectTestCase {
    public void testElementChangedResourceLoadChanged() {
        JaxWsWorkspaceResource resource = new JaxWsWorkspaceResource(null){

            public boolean isLoadCnaceled() {
                return true;
            }
        };
        OnEventModelSynchronizer sync = new OnEventModelSynchronizer(resource, null);
        sync.elementChanged(null);
    }

    public void testGuessPrimaryTypeNameCuInDefaultPackage() {
        Mock javaModel = this.mock(IJavaModel.class);
        JaxWsWorkspaceResource resource = new JaxWsWorkspaceResource((IJavaModel)javaModel.proxy());
        Mock parent = this.mock(IJavaElement.class);
        parent.expects(this.once()).method("getElementName").will(this.returnValue(""));
        Mock cu = this.mock(ICompilationUnit.class);
        cu.expects(this.once()).method("getParent").will(this.returnValue(parent.proxy()));
        cu.expects(this.once()).method("getElementName").will(this.returnValue("MyTest.java"));
        MyOnEventModelSynchronizer sync = new MyOnEventModelSynchronizer(resource, null);
        OnEventModelSyncronizerTest.assertEquals((String)"Incorrect name guessed", (String)"MyTest", (String)sync.guessPrimaryTypeName((ICompilationUnit)cu.proxy()));
    }

    public void testGuessPrimaryTypeNameCuInSomePackage() {
        Mock javaModel = this.mock(IJavaModel.class);
        JaxWsWorkspaceResource resource = new JaxWsWorkspaceResource((IJavaModel)javaModel.proxy());
        Mock parent = this.mock(IJavaElement.class);
        parent.expects(this.once()).method("getElementName").will(this.returnValue("com.sap.demo"));
        Mock cu = this.mock(ICompilationUnit.class);
        cu.expects(this.once()).method("getParent").will(this.returnValue(parent.proxy()));
        cu.expects(this.once()).method("getElementName").will(this.returnValue("MyTest.java"));
        MyOnEventModelSynchronizer sync = new MyOnEventModelSynchronizer(resource, null);
        OnEventModelSyncronizerTest.assertEquals((String)"Incorrect name guessed", (String)"com.sap.demo.MyTest", (String)sync.guessPrimaryTypeName((ICompilationUnit)cu.proxy()));
    }

    public void testRecursevilyHandleAddedPackagesDoesNotProcessNonWsProjects() throws JavaModelException {
        Mock javaModel = this.mock(IJavaModel.class);
        JaxWsWorkspaceResource resource = new JaxWsWorkspaceResource((IJavaModel)javaModel.proxy());
        MyOnEventModelSynchronizer sync = new MyOnEventModelSynchronizer(resource, null);
        Mock delta = this.mock(IJavaElementDelta.class);
        sync.recursevilyHandleAddedPackages((IJavaElementDelta)delta.proxy());
    }

    public class MyOnEventModelSynchronizer
    extends OnEventModelSynchronizer {
        public IWebServiceProject wsProject;

        public MyOnEventModelSynchronizer(JaxWsWorkspaceResource resource, JaxWsWorkspaceResource.ServiceModelData serviceData) {
            super(resource, serviceData);
        }

        protected String guessPrimaryTypeName(ICompilationUnit cu) {
            return super.guessPrimaryTypeName(cu);
        }

        protected void recursevilyHandleAddedPackages(IJavaElementDelta rootDelta) throws JavaModelException {
            super.recursevilyHandleAddedPackages(rootDelta);
        }

        protected IWebServiceProject findProjectByDelta(IJavaElementDelta rootDelta) {
            return this.wsProject;
        }
    }
}

