/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class TextPresentationTest
extends TestCase {
    private static final int NORMAL = 0;
    private static final int BOLD = 1;
    private TextPresentation fTextPresentation;
    private StyleRange[] fAllRanges;
    private StyleRange[] fNonDefaultRanges;
    private Display fDisplay = Display.getDefault();

    public static Test suite() {
        return new TestSuite(TextPresentationTest.class);
    }

    protected void setUp() {
        this.setUpStyleRanges();
        this.setUpTextPresentation();
    }

    private void setUpStyleRanges() {
        this.fAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        this.fNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
    }

    private void setUpTextPresentation() {
        this.fTextPresentation = new TextPresentation();
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 140, 0));
        int i = 0;
        while (i < this.fAllRanges.length) {
            this.fTextPresentation.addStyleRange(this.fAllRanges[i]);
            ++i;
        }
    }

    private StyleRange createStyleRange(int start, int end, int style) {
        return this.createStyleRange(start, end, null, null, style);
    }

    private StyleRange createStyleRange(int start, int end, Color foreground, Color background, int style) {
        return new StyleRange(start, end - start, foreground, background, style);
    }

    private StyleRange createStyleRange(int start, int end, int foreground, int background, int style) {
        return this.createStyleRange(start, end, this.createColor(foreground, foreground, foreground), this.createColor(background, background, background), style);
    }

    private Color createColor(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            return null;
        }
        return new Color((Device)this.fDisplay, red, green, blue);
    }

    private void checkRegions(StyleRange[] expectedAllRanges, StyleRange[] expectedNonDefaultRanges) {
        Iterator e = this.fTextPresentation.getAllStyleRangeIterator();
        int i = 0;
        while (i < expectedAllRanges.length) {
            TextPresentationTest.assertTrue((boolean)e.hasNext());
            TextPresentationTest.assertEquals((Object)expectedAllRanges[i], e.next());
            ++i;
        }
        TextPresentationTest.assertTrue((!e.hasNext() ? 1 : 0) != 0);
        e = this.fTextPresentation.getNonDefaultStyleRangeIterator();
        i = 0;
        while (i < expectedNonDefaultRanges.length) {
            TextPresentationTest.assertTrue((boolean)e.hasNext());
            TextPresentationTest.assertEquals((Object)expectedNonDefaultRanges[i], e.next());
            ++i;
        }
        TextPresentationTest.assertTrue((!e.hasNext() ? 1 : 0) != 0);
    }

    public void testUnclippedRegions() {
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
    }

    public void testClippedRegions1() {
        this.fTextPresentation.setResultWindow((IRegion)new Region(0, 140));
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
    }

    public void testClippedRegions2() {
        this.fTextPresentation.setResultWindow((IRegion)new Region(30, 70));
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 17, 0), this.createStyleRange(17, 24, 1), this.createStyleRange(24, 66, 0), this.createStyleRange(66, 70, 1)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(17, 24, 1), this.createStyleRange(66, 70, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange1() {
        StyleRange range = this.createStyleRange(0, 2, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 2, 1, -1, 0), this.createStyleRange(2, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(0, 2, 1, -1, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange2() {
        StyleRange range = this.createStyleRange(138, 140, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 138, 0), this.createStyleRange(138, 140, 1, -1, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1), this.createStyleRange(138, 140, 1, -1, 0)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange3() {
        StyleRange range = this.createStyleRange(20, 22, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 1, -1, 0), this.createStyleRange(22, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 1, -1, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange4() {
        StyleRange range = this.createStyleRange(22, 24, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0), this.createStyleRange(22, 24, 1, -1, 0), this.createStyleRange(24, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(22, 24, 1, -1, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange5() {
        StyleRange range = this.createStyleRange(45, 47, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 45, 0), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange6() {
        StyleRange range = this.createStyleRange(47, 49, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 49, 1, -1, 1), this.createStyleRange(49, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 49, 1, -1, 1), this.createStyleRange(49, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange7() {
        StyleRange range = this.createStyleRange(49, 51, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 49, 1), this.createStyleRange(49, 51, 1, -1, 1), this.createStyleRange(51, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 49, 1), this.createStyleRange(49, 51, 1, -1, 1), this.createStyleRange(51, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange8() {
        StyleRange range = this.createStyleRange(52, 54, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange9() {
        StyleRange range = this.createStyleRange(45, 49, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 45, 0), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 49, 1, -1, 1), this.createStyleRange(49, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 49, 1, -1, 1), this.createStyleRange(49, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange10() {
        StyleRange range = this.createStyleRange(52, 56, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(54, 56, 1, -1, 0), this.createStyleRange(56, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(54, 56, 1, -1, 0), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange11() {
        StyleRange range = this.createStyleRange(45, 56, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 45, 0), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 54, 1, -1, 1), this.createStyleRange(54, 56, 1, -1, 0), this.createStyleRange(56, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 54, 1, -1, 1), this.createStyleRange(54, 56, 1, -1, 0), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange12() {
        StyleRange range = this.createStyleRange(52, 98, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(54, 96, 1, -1, 0), this.createStyleRange(96, 98, 1, -1, 1), this.createStyleRange(98, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(54, 96, 1, -1, 0), this.createStyleRange(96, 98, 1, -1, 1), this.createStyleRange(98, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange13() {
        StyleRange range = this.createStyleRange(20, 47, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 1, -1, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 1, -1, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRange14() {
        StyleRange range = this.createStyleRange(47, 54, 1, -1, 0);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1, -1, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1, -1, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    public void testMergeStyleRanges1() {
        StyleRange[] ranges = new StyleRange[]{this.createStyleRange(0, 2, 1, -1, 0), this.createStyleRange(20, 22, 1, -1, 0), this.createStyleRange(24, 26, 1, -1, 0), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 49, 1, -1, 0), this.createStyleRange(50, 51, 1, -1, 0), this.createStyleRange(52, 54, 1, -1, 0), this.createStyleRange(138, 140, 1, -1, 0)};
        this.fTextPresentation.mergeStyleRanges(ranges);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 2, 1, -1, 0), this.createStyleRange(2, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 1, -1, 0), this.createStyleRange(22, 24, 0), this.createStyleRange(24, 26, 1, -1, 0), this.createStyleRange(26, 45, 0), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 49, 1, -1, 1), this.createStyleRange(49, 50, 1), this.createStyleRange(50, 51, 1, -1, 1), this.createStyleRange(51, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 138, 0), this.createStyleRange(138, 140, 1, -1, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(0, 2, 1, -1, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 1, -1, 0), this.createStyleRange(24, 26, 1, -1, 0), this.createStyleRange(45, 47, 1, -1, 0), this.createStyleRange(47, 49, 1, -1, 1), this.createStyleRange(49, 50, 1), this.createStyleRange(50, 51, 1, -1, 1), this.createStyleRange(51, 52, 1), this.createStyleRange(52, 54, 1, -1, 1), this.createStyleRange(96, 102, 1), this.createStyleRange(138, 140, 1, -1, 0)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }
}

