/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal.platforms;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.tests.internal.platforms.DTPPlatformTests;

public class DerbyTests
extends DTPPlatformTests {
    private static final String CR = System.getProperty("line.separator");

    public DerbyTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected String getPlatformPropertiesFileName() {
        return "derby.properties";
    }

    @Override
    protected String getDriverName() {
        return "Derby Embedded JDBC Driver";
    }

    @Override
    protected String getDriverDefinitionID() {
        return "DriverDefn.Derby Embedded JDBC Driver";
    }

    @Override
    protected String getDriverDefinitionType() {
        return "org.eclipse.datatools.connectivity.db.derby101.genericDriverTemplate";
    }

    @Override
    protected String getDatabaseVendor() {
        return "Derby";
    }

    @Override
    protected String getDatabaseVersion() {
        return "10.1";
    }

    @Override
    protected String getDriverClass() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    @Override
    protected String getProfileName() {
        return "Derby_10.1_Embedded";
    }

    @Override
    protected String getProfileDescription() {
        return "Derby 10.1 Embedded JDBC Profile [Test]";
    }

    @Override
    protected String getProviderID() {
        return "org.eclipse.datatools.connectivity.db.derby.embedded.connectionProfile";
    }

    @Override
    protected boolean supportsCatalogs() {
        return false;
    }

    @Override
    protected boolean executeOfflineTests() {
        return true;
    }

    public void testSchema() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSchema("TEST1");
        this.dropSchema("TEST2");
        this.executeUpdate("CREATE SCHEMA TEST1");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema1 = this.getDatabase().getSchemaNamed("TEST1");
        DerbyTests.assertNotNull((Object)schema1);
        this.executeUpdate("CREATE SCHEMA TEST2");
        Schema schema2 = this.getDatabase().getSchemaNamed("TEST2");
        DerbyTests.assertNull((Object)schema2);
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        DerbyTests.assertSame((Object)this.getDatabase(), (Object)listener.changedDatabase);
        schema2 = this.getDatabase().getSchemaNamed("TEST2");
        DerbyTests.assertNotNull((Object)schema2);
        DerbyTests.assertNotSame((Object)schema1, (Object)this.getDatabase().getSchemaNamed("TEST1"));
        this.dropSchema("TEST2");
        this.dropSchema("TEST1");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testSchemaLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSchema("LOOKUP_TEST");
        this.dropSchema("\"lookup_TEST\"");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        this.executeUpdate("CREATE SCHEMA LOOKUP_TEST");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaNamed("LOOKUP_TEST"));
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaForIdentifier("LOOKUP_TEST"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaNamed("lookup_test"));
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaForIdentifier("lookup_test"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaNamed("lookup_TEST"));
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaForIdentifier("lookup_TEST"));
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaForIdentifier("\"LOOKUP_TEST\""));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaForIdentifier("\"lookup_TEST\""));
        this.dropSchema("LOOKUP_TEST");
        this.executeUpdate("CREATE SCHEMA \"lookup_TEST\"");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaNamed("LOOKUP_TEST"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaForIdentifier("LOOKUP_TEST"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaNamed("lookup_test"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaForIdentifier("lookup_test"));
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaNamed("lookup_TEST"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaForIdentifier("lookup_TEST"));
        DerbyTests.assertNull((Object)this.getDatabase().getSchemaForIdentifier("\"LOOKUP_TEST\""));
        DerbyTests.assertNotNull((Object)this.getDatabase().getSchemaForIdentifier("\"lookup_TEST\""));
        this.dropSchema("\"lookup_TEST\"");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testSchemaIdentifier() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSchema("LOOKUP_TEST");
        this.dropSchema("\"lookup_TEST\"");
        this.executeUpdate("CREATE SCHEMA lookup_test");
        this.executeUpdate("CREATE SCHEMA \"lookup_TEST\"");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDatabase().getSchemaForIdentifier("LOOKUP_TEST");
        DerbyTests.assertEquals((String)"LOOKUP_TEST", (String)schema.getIdentifier());
        DerbyTests.assertEquals((String)"LOOKUP_TEST", (String)schema.getIdentifier("LookupTest"));
        DerbyTests.assertNull((Object)schema.getIdentifier("Lookup_Test"));
        schema = this.getDatabase().getSchemaForIdentifier("lookup_test");
        DerbyTests.assertEquals((String)"LOOKUP_TEST", (String)schema.getIdentifier());
        schema = this.getDatabase().getSchemaForIdentifier("\"lookup_TEST\"");
        DerbyTests.assertEquals((String)"\"lookup_TEST\"", (String)schema.getIdentifier());
        DerbyTests.assertEquals((String)"\"lookup_TEST\"", (String)schema.getIdentifier("lookup_TEST"));
        this.dropSchema("\"lookup_TEST\"");
        this.dropSchema("LOOKUP_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testTable() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("TABLE_TEST", "FOO_BAZ");
        this.dropTable("TABLE_TEST", "BAZ");
        this.dropTable("TABLE_TEST", "FOO");
        this.dropTable("TABLE_TEST", "BAR");
        this.dropSchema("TABLE_TEST");
        this.executeUpdate("CREATE SCHEMA TABLE_TEST");
        this.executeUpdate("SET SCHEMA = TABLE_TEST");
        this.executeUpdate(this.buildBarDDL());
        this.executeUpdate(this.buildFooDDL());
        this.executeUpdate(this.buildBazDDL());
        this.executeUpdate(this.buildFooBazDDL());
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDatabase().getSchemaNamed("TABLE_TEST");
        Table fooTable = schema.getTableNamed("FOO");
        DerbyTests.assertEquals((int)4, (int)fooTable.getColumnsSize());
        DerbyTests.assertEquals((int)1, (int)fooTable.getPrimaryKeyColumnsSize());
        DerbyTests.assertEquals((int)1, (int)fooTable.getForeignKeysSize());
        Column pkColumn = fooTable.getPrimaryKeyColumn();
        DerbyTests.assertEquals((String)"ID", (String)pkColumn.getName());
        Column idColumn = fooTable.getColumnNamed("ID");
        DerbyTests.assertSame((Object)pkColumn, (Object)idColumn);
        DerbyTests.assertEquals((String)"INTEGER", (String)idColumn.getDataTypeName());
        DerbyTests.assertSame((Object)fooTable, (Object)idColumn.getTable());
        DerbyTests.assertTrue((boolean)idColumn.isPartOfPrimaryKey());
        DerbyTests.assertFalse((boolean)idColumn.isPartOfForeignKey());
        DerbyTests.assertEquals((String)"int", (String)idColumn.getJavaTypeDeclaration());
        Column nameColumn = fooTable.getColumnNamed("NAME");
        DerbyTests.assertEquals((String)"VARCHAR", (String)nameColumn.getDataTypeName());
        DerbyTests.assertEquals((String)"java.lang.String", (String)nameColumn.getJavaTypeDeclaration());
        DerbyTests.assertEquals((int)20, (int)nameColumn.getLength());
        DerbyTests.assertFalse((boolean)nameColumn.isPartOfPrimaryKey());
        DerbyTests.assertFalse((boolean)nameColumn.isNumeric());
        DerbyTests.assertTrue((boolean)nameColumn.isNullable());
        Column barColumn = fooTable.getColumnNamed("BAR_ID");
        DerbyTests.assertEquals((String)"INTEGER", (String)barColumn.getDataTypeName());
        DerbyTests.assertTrue((boolean)barColumn.isPartOfForeignKey());
        DerbyTests.assertFalse((boolean)barColumn.isPartOfPrimaryKey());
        Column salaryColumn = fooTable.getColumnNamed("SALARY");
        DerbyTests.assertEquals((String)"DECIMAL", (String)salaryColumn.getDataTypeName());
        DerbyTests.assertTrue((boolean)salaryColumn.isNullable());
        DerbyTests.assertTrue((boolean)salaryColumn.isNumeric());
        DerbyTests.assertEquals((int)11, (int)salaryColumn.getPrecision());
        DerbyTests.assertEquals((int)2, (int)salaryColumn.getScale());
        DerbyTests.assertEquals((int)-1, (int)salaryColumn.getLength());
        ForeignKey barFK = (ForeignKey)fooTable.getForeignKeys().iterator().next();
        DerbyTests.assertEquals((int)1, (int)barFK.getColumnPairsSize());
        DerbyTests.assertEquals((String)"BAR", (String)barFK.getAttributeName());
        DerbyTests.assertNull((Object)barFK.getJoinColumnAnnotationIdentifier("bar"));
        DerbyTests.assertEquals((String)"BAR_ID", (String)barFK.getJoinColumnAnnotationIdentifier("primaryBar"));
        DerbyTests.assertSame((Object)fooTable, (Object)barFK.getBaseTable());
        DerbyTests.assertFalse((boolean)fooTable.isPossibleJoinTable());
        DerbyTests.assertSame((Object)schema, (Object)fooTable.getSchema());
        Table barTable = schema.getTableNamed("BAR");
        DerbyTests.assertEquals((int)3, (int)barTable.getColumnsSize());
        DerbyTests.assertEquals((int)1, (int)barTable.getPrimaryKeyColumnsSize());
        DerbyTests.assertEquals((int)0, (int)barTable.getForeignKeysSize());
        DerbyTests.assertEquals((String)"ID", (String)barTable.getPrimaryKeyColumn().getName());
        DerbyTests.assertFalse((boolean)barTable.isPossibleJoinTable());
        Column id2Column = barTable.getColumnNamed("ID2");
        DerbyTests.assertEquals((String)"INTEGER", (String)id2Column.getDataTypeName());
        DerbyTests.assertFalse((boolean)id2Column.isNullable());
        DerbyTests.assertTrue((boolean)id2Column.isNumeric());
        DerbyTests.assertEquals((int)0, (int)id2Column.getPrecision());
        DerbyTests.assertEquals((int)0, (int)id2Column.getScale());
        DerbyTests.assertEquals((String)"BLOB", (String)barTable.getColumnNamed("CHUNK").getDataTypeName());
        DerbyTests.assertEquals((String)"byte[]", (String)barTable.getColumnNamed("CHUNK").getJavaTypeDeclaration());
        DerbyTests.assertTrue((boolean)barTable.getColumnNamed("CHUNK").isLOB());
        DerbyTests.assertSame((Object)barTable, (Object)barFK.getReferencedTable());
        Table bazTable = schema.getTableNamed("BAZ");
        Column nicknameColumn = bazTable.getColumnNamed("NICKNAME");
        DerbyTests.assertEquals((int)20, (int)nicknameColumn.getLength());
        Table foo_bazTable = schema.getTableNamed("FOO_BAZ");
        DerbyTests.assertEquals((int)2, (int)foo_bazTable.getColumnsSize());
        DerbyTests.assertEquals((int)0, (int)foo_bazTable.getPrimaryKeyColumnsSize());
        DerbyTests.assertEquals((int)2, (int)foo_bazTable.getForeignKeysSize());
        DerbyTests.assertTrue((boolean)foo_bazTable.isPossibleJoinTable());
        DerbyTests.assertTrue((boolean)foo_bazTable.joinTableNameIsDefault());
        DerbyTests.assertTrue((boolean)foo_bazTable.getColumnNamed("FOO_ID").isPartOfForeignKey());
        this.dropTable("TABLE_TEST", "FOO_BAZ");
        this.dropTable("TABLE_TEST", "BAZ");
        this.dropTable("TABLE_TEST", "FOO");
        this.dropTable("TABLE_TEST", "BAR");
        this.dropSchema("TABLE_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private String buildBarDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE BAR (").append(CR);
        sb.append("    ID INT PRIMARY KEY,").append(CR);
        sb.append("    ID2 INT UNIQUE NOT NULL,").append(CR);
        sb.append("    CHUNK BLOB(100K)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE FOO (").append(CR);
        sb.append("    ID INT PRIMARY KEY,").append(CR);
        sb.append("    NAME VARCHAR(20),").append(CR);
        sb.append("    SALARY DECIMAL(11, 2),").append(CR);
        sb.append("    BAR_ID INT REFERENCES BAR(ID)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE BAZ (").append(CR);
        sb.append("    ID INT PRIMARY KEY,").append(CR);
        sb.append("    NICKNAME VARCHAR(20) NOT NULL UNIQUE").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE FOO_BAZ (").append(CR);
        sb.append("    FOO_ID INT REFERENCES FOO(ID),").append(CR);
        sb.append("    BAZ_ID INT REFERENCES BAZ(ID)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    public void testColumnLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("COLUMN_TEST", "test");
        this.dropSchema("COLUMN_TEST");
        this.executeUpdate("CREATE SCHEMA COLUMN_TEST");
        this.executeUpdate("SET SCHEMA = COLUMN_TEST");
        this.executeUpdate("CREATE TABLE test (id INTEGER, name VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Table table = this.getDatabase().getSchemaNamed("COLUMN_TEST").getTableForIdentifier("test");
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        this.dropTable("COLUMN_TEST", "test");
        this.executeUpdate("CREATE TABLE test (ID INTEGER, NAME VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDatabase().getSchemaNamed("COLUMN_TEST").getTableForIdentifier("test");
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("ID"));
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("NAME"));
        this.dropTable("COLUMN_TEST", "test");
        this.executeUpdate("CREATE TABLE test (Id INTEGER, Name VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDatabase().getSchemaNamed("COLUMN_TEST").getTableForIdentifier("test");
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("Id"));
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("Name"));
        this.dropTable("COLUMN_TEST", "test");
        this.executeUpdate("CREATE TABLE test (\"Id\" INTEGER, \"Name\" VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDatabase().getSchemaNamed("COLUMN_TEST").getTableForIdentifier("test");
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("\"Id\""));
        DerbyTests.assertNotNull((Object)table.getColumnForIdentifier("\"Name\""));
        this.dropTable("COLUMN_TEST", "test");
        this.dropSchema("COLUMN_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testCrossSchemaReference() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("XREF_TEST2", "EMP");
        this.dropSchema("XREF_TEST2");
        this.dropTable("XREF_TEST1", "ORG");
        this.dropSchema("XREF_TEST1");
        this.executeUpdate("CREATE SCHEMA XREF_TEST1");
        this.executeUpdate("SET SCHEMA = XREF_TEST1");
        this.executeUpdate("CREATE TABLE ORG (ID INTEGER PRIMARY KEY, NAME VARCHAR(20))");
        this.executeUpdate("CREATE SCHEMA XREF_TEST2");
        this.executeUpdate("SET SCHEMA = XREF_TEST2");
        this.executeUpdate("CREATE TABLE EMP (ID INTEGER PRIMARY KEY, NAME VARCHAR(20), ORG_ID INTEGER REFERENCES XREF_TEST1.ORG(ID))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema1 = this.getDatabase().getSchemaNamed("XREF_TEST1");
        DerbyTests.assertNotNull((Object)schema1);
        Table orgTable = schema1.getTableNamed("ORG");
        DerbyTests.assertNotNull((Object)orgTable);
        Schema schema2 = this.getDatabase().getSchemaNamed("XREF_TEST2");
        DerbyTests.assertNotNull((Object)schema2);
        Table empTable = schema2.getTableNamed("EMP");
        DerbyTests.assertNotNull((Object)empTable);
        DerbyTests.assertEquals((int)1, (int)empTable.getForeignKeysSize());
        ForeignKey fk = (ForeignKey)empTable.getForeignKeys().iterator().next();
        Table refTable = fk.getReferencedTable();
        DerbyTests.assertNotNull((Object)refTable);
        DerbyTests.assertEquals((String)"ORG", (String)refTable.getName());
        DerbyTests.assertEquals((int)1, (int)fk.getColumnPairsSize());
        ForeignKey.ColumnPair cp = (ForeignKey.ColumnPair)fk.getColumnPairs().iterator().next();
        Column baseColumn = cp.getBaseColumn();
        DerbyTests.assertEquals((String)"ORG_ID", (String)baseColumn.getName());
        Column refColumn = cp.getReferencedColumn();
        DerbyTests.assertEquals((String)"ID", (String)refColumn.getName());
        this.dropTable("XREF_TEST2", "EMP");
        this.dropSchema("XREF_TEST2");
        this.dropTable("XREF_TEST1", "ORG");
        this.dropSchema("XREF_TEST1");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private void dropTable(String schemaName, String tableName) throws Exception {
        Schema schema = this.getDatabase().getSchemaForIdentifier(schemaName);
        if (schema != null && schema.getTableForIdentifier(tableName) != null) {
            this.executeUpdate("DROP TABLE " + schemaName + '.' + tableName);
        }
    }

    private void dropSchema(String name) throws Exception {
        if (this.getDatabase().getSchemaForIdentifier(name) != null) {
            this.executeUpdate("DROP SCHEMA " + name + " RESTRICT");
        }
    }
}

