/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.WriteRenderKitTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteRenderKitTestCase_1_2
extends WriteRenderKitTestCase {
    private static final String EXTENDED_RENDERKIT_ID = "extended-renderkit-rule-id";
    private static final String RENDERKIT_EXTENSION = CommonStructuresUtil.createPreficedString("render-kit", "extension");
    private static final String RENDERKIT_EXTENSION_ID = CommonStructuresUtil.createPreficedString(RENDERKIT_EXTENSION, "id");
    private static final String RENDERKIT_EXTENSION_TAG = CommonStructuresUtil.createPreficedString(RENDERKIT_EXTENSION, "tag");

    public WriteRenderKitTestCase_1_2(String name) {
        super(name);
    }

    public void testRenderKitExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteRenderKitTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            RenderKitType renderKit = facesConfigFactory.createRenderKitType();
            renderKit.setId(EXTENDED_RENDERKIT_ID);
            RenderKitExtensionType extensionType = facesConfigFactory.createRenderKitExtensionType();
            extensionType.setId(RENDERKIT_EXTENSION_ID);
            extensionType.getChildNodes().add((Object)this.createDynamicElement(RENDERKIT_EXTENSION_TAG));
            renderKit.getRenderKitExtension().add((Object)extensionType);
            edit.getFacesConfig().getRenderKit().add((Object)renderKit);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteRenderKitTestCase_1_2.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteRenderKitTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            RenderKitType renderKit = (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getRenderKit(), EXTENDED_RENDERKIT_ID);
            WriteRenderKitTestCase_1_2.assertNotNull((Object)renderKit);
            WriteRenderKitTestCase_1_2.assertEquals((int)1, (int)renderKit.getRenderKitExtension().size());
            RenderKitExtensionType extensionType = (RenderKitExtensionType)renderKit.getRenderKitExtension().get(0);
            WriteRenderKitTestCase_1_2.assertEquals((String)RENDERKIT_EXTENSION_ID, (String)extensionType.getId());
            WriteRenderKitTestCase_1_2.assertEquals((int)1, (int)extensionType.getChildNodes().size());
            DynamicElement element = (DynamicElement)extensionType.getChildNodes().get(0);
            WriteRenderKitTestCase_1_2.assertEquals((String)RENDERKIT_EXTENSION_TAG, (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

