/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import org.easymock.EasyMock;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramsPackage;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.junit.Before;
import org.junit.Test;

public class AddJPAEntityFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private Diagram diagram;
    public static IGaService gas = Graphiti.getGaService();

    @Before
    public void setUp() throws Exception {
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getAttribsNum((Shape)EasyMock.anyObject())).andStubReturn((Object)0);
        IDiagramTypeProvider idp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andStubReturn((Object)idp);
        EasyMock.expect((Object)this.featureProvider.increaseAttribsNum((Shape)EasyMock.anyObject())).andStubReturn((Object)1);
        this.diagram = (Diagram)EasyMock.createMock(Diagram.class);
        EasyMock.expect((Object)idp.getDiagram()).andStubReturn((Object)this.diagram);
        Color c = (Color)EasyMock.createMock(Color.class);
        EasyMock.expect((Object)c.getBlue()).andStubReturn((Object)0);
        EasyMock.expect((Object)c.getRed()).andStubReturn((Object)0);
        EasyMock.expect((Object)c.getGreen()).andStubReturn((Object)0);
        BasicInternalEList col = new BasicInternalEList(Color.class);
        EasyMock.expect((Object)this.diagram.getColors()).andStubReturn((Object)col);
        BasicInternalEList fonts = new BasicInternalEList(Font.class);
        EasyMock.expect((Object)this.diagram.getFonts()).andStubReturn((Object)fonts);
        EasyMock.replay((Object[])new Object[]{this.diagram, c, idp, this.featureProvider});
    }

    @Test
    public void testAddText() {
        Text t = (Text)EasyMock.createMock(Text.class);
        Font f = gas.manageFont(this.diagram, "Arial", 8, true, false);
        t.setFont(f);
        EasyMock.expectLastCall().asStub();
        EasyMock.expect((Object)t.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)t.getY()).andStubReturn((Object)0);
        t.setWidth(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        t.setHeight(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        t.setValue("abc");
        EasyMock.expectLastCall().asStub();
        t.setForeground((Color)EasyMock.anyObject());
        EasyMock.expectLastCall().asStub();
        t.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        EasyMock.expectLastCall().asStub();
        t.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        EasyMock.expectLastCall().asStub();
        Font f1 = gas.manageFont(this.diagram, "Arial", 8, false, true);
        EasyMock.expect((Object)t.getFont()).andStubReturn((Object)f1);
        Rectangle textRectangle = (Rectangle)EasyMock.createMock(Rectangle.class);
        BasicInternalEList lst = new BasicInternalEList(GraphicsAlgorithm.class);
        EasyMock.expect((Object)textRectangle.getGraphicsAlgorithmChildren()).andStubReturn((Object)lst);
        EasyMock.replay((Object[])new Object[]{t, textRectangle});
        UpdateAttributeFeature.addText((IFeatureProvider)this.featureProvider, (Rectangle)textRectangle, (String)"abc");
    }

    @Test
    public void testaddRectangleForIcon() {
        ContainerShape cs = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        Rectangle rect = (Rectangle)EasyMock.createMock(Rectangle.class);
        EasyMock.expect((Object)rect.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)rect.getY()).andStubReturn((Object)0);
        rect.setWidth(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        rect.setHeight(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        cs.setGraphicsAlgorithm((GraphicsAlgorithm)rect);
        EasyMock.expectLastCall().asStub();
        rect.setFilled(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        rect.setX(EasyMock.anyInt());
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        rect.setY(EasyMock.anyInt());
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        rect.setWidth(EasyMock.anyInt());
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        cs.setGraphicsAlgorithm((GraphicsAlgorithm)EasyMock.isA(Rectangle.class));
        EasyMock.expectLastCall().asStub();
        EasyMock.replay((Object[])new Object[]{rect, cs});
        UpdateAttributeFeature.addRectangleForIcon((ContainerShape)cs, (int)0);
    }

    @Test
    public void testAddRectangleForText() {
        ContainerShape cs = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        Rectangle rect = (Rectangle)EasyMock.createMock(Rectangle.class);
        EasyMock.expect((Object)rect.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)rect.getY()).andStubReturn((Object)0);
        rect.setWidth(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        rect.setHeight(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        cs.setGraphicsAlgorithm((GraphicsAlgorithm)rect);
        EasyMock.expectLastCall().asStub();
        rect.setFilled(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        rect.setX(EasyMock.anyInt());
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        rect.setY(EasyMock.anyInt());
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        rect.setWidth(EasyMock.anyInt());
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        cs.setGraphicsAlgorithm((GraphicsAlgorithm)EasyMock.isA(Rectangle.class));
        EasyMock.expectLastCall().asStub();
        EasyMock.replay((Object[])new Object[]{rect, cs});
        UpdateAttributeFeature.addRectangleForText((ContainerShape)cs, (int)0, (int)120);
    }

    @Test
    public void testAddAttribute() {
        GraphicsAlgorithm ga = (GraphicsAlgorithm)EasyMock.createMock(GraphicsAlgorithm.class);
        EasyMock.expect((Object)ga.getWidth()).andStubReturn((Object)20);
        ContainerShape cs = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)cs.getGraphicsAlgorithm()).andStubReturn((Object)ga);
        Rectangle rect = (Rectangle)EasyMock.createMock(Rectangle.class);
        EasyMock.expect((Object)rect.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)rect.getY()).andStubReturn((Object)0);
        rect.setWidth(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        rect.setHeight(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        rect.setFilled(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        rect.setLineVisible(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        rect.setX(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        rect.setY(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        BasicInternalEList props = new BasicInternalEList(Property.class);
        BasicInternalEList props1 = new BasicInternalEList(Property.class);
        EasyMock.expect((Object)cs.getProperties()).andStubReturn((Object)props);
        cs.setVisible(EasyMock.anyBoolean());
        EasyMock.expectLastCall().asStub();
        cs.setActive(EasyMock.anyBoolean());
        EasyMock.expectLastCall().asStub();
        cs.setContainer((ContainerShape)EasyMock.anyObject());
        EasyMock.expectLastCall().asStub();
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)cs1.getProperties()).andStubReturn((Object)props1);
        cs1.setVisible(EasyMock.anyBoolean());
        EasyMock.expectLastCall().asStub();
        cs1.setActive(EasyMock.anyBoolean());
        EasyMock.expectLastCall().asStub();
        cs1.setContainer((ContainerShape)EasyMock.anyObject());
        EasyMock.expectLastCall().asStub();
        PictogramsPackage p = (PictogramsPackage)EasyMock.createMock(PictogramsPackage.class);
        Property pr = (Property)EasyMock.createMock(Property.class);
        cs1.setGraphicsAlgorithm((GraphicsAlgorithm)EasyMock.anyObject());
        EasyMock.expectLastCall().asStub();
        Image img = (Image)EasyMock.createMock(Image.class);
        EasyMock.expect((Object)img.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)img.getY()).andStubReturn((Object)0);
        img.setWidth(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        img.setHeight(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        img.setX(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        img.setY(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        img.setId("org.eclisp.jpt.ui.diagrameditor.field");
        EasyMock.expectLastCall().asStub();
        img.setProportional(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        img.setStretchH(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        img.setStretchV(Boolean.valueOf(EasyMock.anyBoolean()));
        EasyMock.expectLastCall().asStub();
        BasicInternalEList ch = new BasicInternalEList(GraphicsAlgorithm.class);
        EasyMock.expect((Object)rect.getGraphicsAlgorithmChildren()).andStubReturn((Object)ch);
        EasyMock.expect((Object)pr.getKey()).andStubReturn((Object)"prop_shape_type");
        Text t = (Text)EasyMock.createMock(Text.class);
        EasyMock.expect((Object)t.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)t.getY()).andStubReturn((Object)0);
        t.setWidth(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        t.setX(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        t.setY(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        t.setHeight(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        t.setValue("");
        EasyMock.expectLastCall().asStub();
        Font f = gas.manageFont(this.diagram, "Arial", 8, false, true);
        EasyMock.expect((Object)t.getFont()).andStubReturn((Object)f);
        t.setFont((Font)EasyMock.anyObject());
        EasyMock.expectLastCall().asStub();
        EasyMock.expectLastCall().asStub();
        t.setForeground((Color)EasyMock.anyObject());
        t.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        t.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        EasyMock.replay((Object[])new Object[]{rect, ga, img, cs, cs1, p, pr, t});
    }
}

