/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class AbstractASTTests
extends ModifyingResourceTests {
    public AbstractASTTests(String name) {
        super(name);
    }

    protected void assertASTNodeEquals(String expected, ASTNode node) {
        String actual = node.toString();
        if (!expected.equals(actual)) {
            System.out.println(String.valueOf(this.displayString(actual, 3)) + ",");
        }
        AbstractASTTests.assertEquals((String)"Unexpected ast node", (String)expected, (String)actual);
    }

    protected void assertASTNodesEqual(String expected, List nodes) {
        StringBuffer buffer = new StringBuffer();
        for (ASTNode node : nodes) {
            IProblem[] problems;
            buffer.append(node);
            if (node instanceof JavaScriptUnit && (problems = ((JavaScriptUnit)node).getProblems()) != null) {
                int i = 0;
                int length = problems.length;
                while (i < length) {
                    IProblem problem = problems[i];
                    buffer.append('\n');
                    buffer.append(problem);
                    ++i;
                }
            }
            buffer.append('\n');
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.println(String.valueOf(this.displayString(actual, 4)) + ",");
        }
        AbstractASTTests.assertEquals((String)"Unexpected ast nodes", (String)expected, (String)actual);
    }

    protected void assertBindingKeyEquals(String expected, String actual) {
        this.assertBindingKeysEqual(expected, new String[]{actual});
    }

    protected void assertBindingKeysEqual(String expected, String[] actualKeys) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = actualKeys.length;
        while (i < length) {
            if (i > 0) {
                buffer.append('\n');
            }
            buffer.append(actualKeys[i]);
            ++i;
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.print(this.displayString(actual, 4));
            System.out.println(',');
        }
        AbstractASTTests.assertEquals((String)"Unexpected binding keys", (String)expected, (String)actual);
    }

    protected void assertBindingEquals(String expected, IBinding binding) {
        this.assertBindingsEqual(expected, new IBinding[]{binding});
    }

    protected void assertBindingsEqual(String expected, IBinding[] actualBindings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = actualBindings.length;
        while (i < length) {
            if (i > 0) {
                buffer.append('\n');
            }
            if (actualBindings[i] == null) {
                buffer.append("<null>");
            } else {
                buffer.append(actualBindings[i].getKey());
            }
            ++i;
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.print(this.displayString(actual, 3));
            System.out.println(',');
        }
        AbstractASTTests.assertEquals((String)"Unexpected bindings", (String)expected, (String)actual);
    }

    protected ASTNode buildAST(MarkerInfo markerInfo, IClassFile classFile, boolean reportErrors) throws JavaScriptModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(classFile);
        parser.setResolveBindings(true);
        JavaScriptUnit unit = (JavaScriptUnit)parser.createAST(null);
        if (reportErrors) {
            StringBuffer buffer = new StringBuffer();
            IProblem[] problems = unit.getProblems();
            int i = 0;
            int length = problems.length;
            while (i < length) {
                Util.appendProblem((StringBuffer)buffer, (IProblem)problems[i], (char[])markerInfo.source.toCharArray(), (int)(i + 1));
                ++i;
            }
            if (buffer.length() > 0) {
                System.err.println(buffer.toString());
            }
        }
        return this.findNode(unit, markerInfo);
    }

    protected ASTNode buildAST(IJavaScriptUnit cu) throws JavaScriptModelException {
        return this.buildAST(null, cu, true);
    }

    protected ASTNode buildAST(String newContents, IJavaScriptUnit cu) throws JavaScriptModelException {
        return this.buildAST(newContents, cu, true);
    }

    protected ASTNode buildAST(MarkerInfo markerInfo, IClassFile classFile) throws JavaScriptModelException {
        return this.buildAST(markerInfo, classFile, true);
    }

    protected ASTNode buildAST(String newContents, IJavaScriptUnit cu, boolean reportErrors) throws JavaScriptModelException {
        return this.buildAST(newContents, cu, reportErrors, false);
    }

    protected ASTNode buildAST(String newContents, IJavaScriptUnit cu, boolean reportErrors, boolean enableStatementRecovery) throws JavaScriptModelException {
        ASTNode[] nodes = this.buildASTs(newContents, cu, reportErrors, enableStatementRecovery);
        if (nodes.length == 0) {
            return null;
        }
        return nodes[0];
    }

    protected ASTNode[] buildASTs(String contents, IJavaScriptUnit cu) throws JavaScriptModelException {
        return this.buildASTs(contents, cu, true);
    }

    protected ASTNode[] buildASTs(String newContents, IJavaScriptUnit cu, boolean reportErrors) throws JavaScriptModelException {
        return this.buildASTs(newContents, cu, reportErrors, false);
    }

    protected ASTNode[] buildASTs(String newContents, IJavaScriptUnit cu, boolean reportErrors, boolean enableStatementRecovery) throws JavaScriptModelException {
        ASTNode[] nodes;
        Object buffer;
        JavaScriptUnit unit;
        MarkerInfo markerInfo = newContents == null ? new MarkerInfo(cu.getSource()) : new MarkerInfo(newContents);
        newContents = markerInfo.source;
        if (cu.isWorkingCopy()) {
            cu.getBuffer().setContents(newContents);
            unit = cu.reconcile(3, reportErrors, enableStatementRecovery, null, null);
        } else {
            buffer = cu.getBuffer();
            buffer.setContents(newContents);
            buffer.save(null, false);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            parser.setResolveBindings(true);
            parser.setStatementsRecovery(enableStatementRecovery);
            unit = (JavaScriptUnit)parser.createAST(null);
        }
        if (reportErrors) {
            buffer = new StringBuffer();
            IProblem[] problems = unit.getProblems();
            int i = 0;
            int length = problems.length;
            while (i < length) {
                Util.appendProblem((StringBuffer)buffer, (IProblem)problems[i], (char[])newContents.toCharArray(), (int)(i + 1));
                ++i;
            }
            if (((StringBuffer)buffer).length() > 0) {
                System.err.println(((StringBuffer)buffer).toString());
            }
        }
        if ((nodes = this.findNodes(unit, markerInfo)).length == 0) {
            return new ASTNode[]{unit};
        }
        return nodes;
    }

    protected MarkerInfo[] createMarkerInfos(String[] pathAndSources) {
        MarkerInfo[] markerInfos = new MarkerInfo[pathAndSources.length / 2];
        int index = 0;
        int i = 0;
        int length = pathAndSources.length;
        while (i < length) {
            String path = pathAndSources[i];
            String source = pathAndSources[++i];
            markerInfos[index++] = new MarkerInfo(path, source);
            ++i;
        }
        return markerInfos;
    }

    protected IVariableBinding[] createVariableBindings(String[] pathAndSources, String[] bindingKeys) throws JavaScriptModelException {
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies = this.createWorkingCopies(pathAndSources, owner);
        IBinding[] bindings = this.resolveBindings(bindingKeys, this.getJavaProject("P"), owner);
        int length = bindings.length;
        IVariableBinding[] result = new IVariableBinding[length];
        System.arraycopy(bindings, 0, result, 0, length);
        return result;
    }

    protected IFunctionBinding[] createMethodBindings(String[] pathAndSources, String[] bindingKeys) throws JavaScriptModelException {
        return this.createMethodBindings(pathAndSources, bindingKeys, this.getJavaProject("P"));
    }

    protected IFunctionBinding[] createMethodBindings(String[] pathAndSources, String[] bindingKeys, IJavaScriptProject project) throws JavaScriptModelException {
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies = this.createWorkingCopies(pathAndSources, owner);
        IBinding[] bindings = this.resolveBindings(bindingKeys, project, owner);
        int length = bindings.length;
        IFunctionBinding[] result = new IFunctionBinding[length];
        System.arraycopy(bindings, 0, result, 0, length);
        return result;
    }

    protected ITypeBinding[] createTypeBindings(String[] pathAndSources, String[] bindingKeys) throws JavaScriptModelException {
        return this.createTypeBindings(pathAndSources, bindingKeys, this.getJavaProject("P"));
    }

    protected ITypeBinding[] createTypeBindings(String[] pathAndSources, String[] bindingKeys, IJavaScriptProject project) throws JavaScriptModelException {
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies = this.createWorkingCopies(pathAndSources, owner);
        IBinding[] bindings = this.resolveBindings(bindingKeys, project, owner);
        int length = bindings.length;
        ITypeBinding[] result = new ITypeBinding[length];
        System.arraycopy(bindings, 0, result, 0, length);
        return result;
    }

    protected IJavaScriptUnit[] createWorkingCopies(String[] pathAndSources, WorkingCopyOwner owner) throws JavaScriptModelException {
        MarkerInfo[] markerInfos = this.createMarkerInfos(pathAndSources);
        return this.createWorkingCopies(markerInfos, owner);
    }

    protected IJavaScriptUnit[] createWorkingCopies(MarkerInfo[] markerInfos, WorkingCopyOwner owner) throws JavaScriptModelException {
        return this.createWorkingCopies(markerInfos, owner, null);
    }

    protected IJavaScriptUnit[] createWorkingCopies(MarkerInfo[] markerInfos, WorkingCopyOwner owner, IProblemRequestor problemRequestor) throws JavaScriptModelException {
        int length = markerInfos.length;
        IJavaScriptUnit[] copies = new IJavaScriptUnit[length];
        int i = 0;
        while (i < length) {
            MarkerInfo markerInfo = markerInfos[i];
            IJavaScriptUnit workingCopy = this.getCompilationUnit(markerInfo.path).getWorkingCopy(owner, null);
            workingCopy.getBuffer().setContents(markerInfo.source);
            workingCopy.makeConsistent(null);
            copies[i] = workingCopy;
            ++i;
        }
        return copies;
    }

    protected ASTNode findNode(JavaScriptUnit unit, MarkerInfo markerInfo) {
        ASTNode[] nodes = this.findNodes(unit, markerInfo);
        if (nodes.length == 0) {
            return unit;
        }
        return nodes[0];
    }

    protected ASTNode[] findNodes(JavaScriptUnit unit, MarkerInfo markerInfo) {
        class Visitor
        extends ASTVisitor {
            ArrayList found = new ArrayList();
            private final /* synthetic */ MarkerInfo val$markerInfo;

            Visitor(MarkerInfo markerInfo) {
                this.val$markerInfo = markerInfo;
            }

            public void preVisit(ASTNode node) {
                if (node instanceof JavaScriptUnit) {
                    return;
                }
                int index = this.val$markerInfo.indexOfASTStart(node.getStartPosition());
                if (index != -1 && node.getStartPosition() + node.getLength() == this.val$markerInfo.astEnds[index]) {
                    this.found.add(node);
                    this.val$markerInfo.astStarts[index] = -1;
                }
            }
        }
        Visitor visitor = new Visitor(markerInfo);
        unit.accept((ASTVisitor)visitor);
        int size = visitor.found.size();
        ASTNode[] result = new ASTNode[size];
        visitor.found.toArray(result);
        return result;
    }

    protected void resolveASTs(IJavaScriptUnit[] cus, String[] bindingKeys, ASTRequestor requestor, IJavaScriptProject project, WorkingCopyOwner owner) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(project);
        parser.setWorkingCopyOwner(owner);
        parser.createASTs(cus, bindingKeys, requestor, null);
    }

    protected IBinding resolveBinding(ASTNode node) {
        switch (node.getNodeType()) {
            case 35: {
                return ((PackageDeclaration)node).resolveBinding();
            }
            case 55: {
                return ((TypeDeclaration)node).resolveBinding();
            }
            case 1: {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            case 56: {
                return ((TypeDeclarationStatement)node).resolveBinding();
            }
            case 31: {
                return ((FunctionDeclaration)node).resolveBinding();
            }
            case 32: {
                return ((FunctionInvocation)node).resolveMethodBinding();
            }
            case 42: {
                return ((SimpleName)node).resolveBinding();
            }
            case 5: {
                return ((ArrayType)node).resolveBinding();
            }
            case 7: {
                return ((Assignment)node).getRightHandSide().resolveTypeBinding();
            }
            case 43: {
                return ((SimpleType)node).resolveBinding();
            }
            case 40: {
                return ((QualifiedName)node).resolveBinding();
            }
        }
        throw new Error("Not yet implemented for this type of node: " + node);
    }

    protected IBinding[] resolveBindings(String[] bindingKeys, IJavaScriptProject project, WorkingCopyOwner owner) {
        BindingRequestor requestor = new BindingRequestor();
        this.resolveASTs(new IJavaScriptUnit[0], bindingKeys, requestor, project, owner);
        return requestor.getBindings(bindingKeys);
    }

    protected IBinding[] resolveBindings(String contents, IJavaScriptUnit cu) throws JavaScriptModelException {
        return this.resolveBindings(contents, cu, true);
    }

    protected IBinding[] resolveBindings(String contents, IJavaScriptUnit cu, boolean reportErrors) throws JavaScriptModelException {
        ASTNode[] nodes = this.buildASTs(contents, cu, reportErrors);
        if (nodes == null) {
            return null;
        }
        int length = nodes.length;
        IBinding[] result = new IBinding[length];
        int i = 0;
        while (i < length) {
            result[i] = this.resolveBinding(nodes[i]);
            ++i;
        }
        return result;
    }

    public class BindingRequestor
    extends ASTRequestor {
        HashMap bindings = new HashMap();

        public void acceptBinding(String bindingKey, IBinding binding) {
            this.bindings.put(bindingKey, binding);
        }

        public IBinding[] getBindings(String[] bindingKeys) {
            int length = this.bindings.size();
            IBinding[] result = new IBinding[length];
            int i = 0;
            while (i < length) {
                result[i] = (IBinding)this.bindings.get(bindingKeys[i]);
                ++i;
            }
            return result;
        }
    }

    public class MarkerInfo {
        String path;
        String source;
        int[] astStarts;
        int[] astEnds;

        public MarkerInfo(String source) {
            this(null, source);
        }

        public MarkerInfo(String path, String source) {
            this.path = path;
            this.source = source;
            int markerIndex = 1;
            while (source.indexOf("/*start" + markerIndex + "*/") != -1) {
                ++markerIndex;
            }
            int astNumber = source.indexOf("/*start*/") != -1 ? markerIndex : markerIndex - 1;
            this.astStarts = new int[astNumber];
            this.astEnds = new int[astNumber];
            int i = 1;
            while (i < markerIndex) {
                this.setStartAndEnd(i);
                ++i;
            }
            if (astNumber == markerIndex) {
                this.setStartAndEnd(-1);
            }
        }

        public int indexOfASTStart(int astStart) {
            int i = 0;
            int length = this.astStarts.length;
            while (i < length) {
                if (this.astStarts[i] == astStart) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void removeMarkerFromSource(String marker, int sourceIndex, int astNumber) {
            char[] markerChars = marker.toCharArray();
            this.source = new String(CharOperation.replace((char[])this.source.toCharArray(), (char[])markerChars, (char[])CharOperation.NO_CHAR));
            int markerLength = markerChars.length;
            int i = 0;
            while (i < astNumber) {
                if (this.astStarts[i] > sourceIndex) {
                    int n = i;
                    this.astStarts[n] = this.astStarts[n] - markerLength;
                }
                if (this.astEnds[i] > sourceIndex) {
                    int n = i;
                    this.astEnds[n] = this.astEnds[n] - markerLength;
                }
                ++i;
            }
        }

        private void setStartAndEnd(int markerIndex) {
            int astEnd;
            int astStart;
            String markerNumber;
            if (markerIndex == -1) {
                markerNumber = "";
                markerIndex = this.astStarts.length;
            } else {
                markerNumber = Integer.toString(markerIndex);
            }
            String markerStart = "/*start" + markerNumber + "*/";
            String markerEnd = "/*end" + markerNumber + "*/";
            this.astStarts[markerIndex - 1] = astStart = this.source.indexOf(markerStart);
            this.removeMarkerFromSource(markerStart, astStart, markerIndex - 1);
            this.astEnds[markerIndex - 1] = astEnd = this.source.indexOf(markerEnd);
            this.removeMarkerFromSource(markerEnd, astEnd, markerIndex - 1);
        }
    }
}

