/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.stack;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.stack.FixedCapacityArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.stack.StackTests;

public class FixedCapacityArrayStackTests
extends StackTests {
    public FixedCapacityArrayStackTests(String name) {
        super(name);
    }

    FixedCapacityArrayStack<String> buildStack() {
        return StackTools.fixedCapacityArrayStack((int)10);
    }

    public void testCollectionConstructor() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("first");
        c.add("second");
        c.add("third");
        c.add("fourth");
        c.add("fifth");
        c.add("sixth");
        c.add("seventh");
        c.add("eighth");
        c.add("ninth");
        c.add("tenth");
        FixedCapacityArrayStack stack = StackTools.fixedCapacityArrayStack(c);
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        FixedCapacityArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.peek()));
        FixedCapacityArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"ninth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        FixedCapacityArrayStackTests.assertEquals((String)"eighth", (String)((String)stack.peek()));
        FixedCapacityArrayStackTests.assertEquals((String)"eighth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"seventh", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"sixth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"fifth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"fourth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"third", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"second", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"first", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testIsFull() {
        FixedCapacityArrayStack<String> stack = this.buildStack();
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isFull());
        stack.push((Object)"first");
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isFull());
        stack.push((Object)"second");
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isFull());
        stack.push((Object)"third");
        stack.push((Object)"fourth");
        stack.push((Object)"fifth");
        stack.push((Object)"sixth");
        stack.push((Object)"seventh");
        stack.push((Object)"eighth");
        stack.push((Object)"ninth");
        stack.push((Object)"tenth");
        FixedCapacityArrayStackTests.assertTrue((boolean)stack.isFull());
        stack.pop();
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isFull());
    }

    public void testArrayCapacityExceeded() {
        FixedCapacityArrayStack<String> stack = this.buildStack();
        FixedCapacityArrayStackTests.assertTrue((boolean)stack.isEmpty());
        stack.push((Object)"first");
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        stack.push((Object)"second");
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        stack.push((Object)"third");
        stack.push((Object)"fourth");
        stack.push((Object)"fifth");
        stack.push((Object)"sixth");
        stack.push((Object)"seventh");
        stack.push((Object)"eighth");
        stack.push((Object)"ninth");
        stack.push((Object)"tenth");
        boolean exCaught = false;
        try {
            stack.push((Object)"eleventh");
            FixedCapacityArrayStackTests.fail((String)"bogus");
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayStackTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        FixedCapacityArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.peek()));
        FixedCapacityArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"ninth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertFalse((boolean)stack.isEmpty());
        FixedCapacityArrayStackTests.assertEquals((String)"eighth", (String)((String)stack.peek()));
        FixedCapacityArrayStackTests.assertEquals((String)"eighth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"seventh", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"sixth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"fifth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"fourth", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"third", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"second", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertEquals((String)"first", (String)((String)stack.pop()));
        FixedCapacityArrayStackTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testSerialization_fullArray() throws Exception {
        FixedCapacityArrayStack stack = new FixedCapacityArrayStack(3);
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        this.verifyClone((Stack<String>)stack, (Stack<String>)((Stack)TestTools.serialize(stack)));
    }

    public void testConstructorInt_IAE() throws Exception {
        boolean exCaught = false;
        try {
            FixedCapacityArrayStack stack = StackTools.fixedCapacityArrayStack((int)-3);
            FixedCapacityArrayStackTests.fail((String)("bogus stack: " + stack));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        FixedCapacityArrayStackTests.assertTrue((boolean)exCaught);
    }

    public void testToString_empty() throws Exception {
        FixedCapacityArrayStack<String> stack = this.buildStack();
        FixedCapacityArrayStackTests.assertEquals((String)"[]", (String)stack.toString());
    }
}

