/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.NullInputStream;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class NullInputStreamTests
extends TestCase {
    private InputStream nullInputStream;

    public NullInputStreamTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.nullInputStream = NullInputStream.instance();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testAvailable() throws IOException {
        NullInputStreamTests.assertEquals((int)0, (int)this.nullInputStream.available());
    }

    public void testClose() throws IOException {
        this.nullInputStream.close();
    }

    public void testMark() {
        this.nullInputStream.mark(5);
    }

    public void testMarkSupported() {
        NullInputStreamTests.assertFalse((boolean)this.nullInputStream.markSupported());
    }

    public void testRead() throws IOException {
        NullInputStreamTests.assertEquals((int)-1, (int)this.nullInputStream.read());
    }

    public void testReadByteArray() throws IOException {
        byte[] expected = new byte[10];
        Arrays.fill(expected, (byte)7);
        byte[] actual = new byte[10];
        Arrays.fill(actual, (byte)7);
        NullInputStreamTests.assertEquals((int)-1, (int)this.nullInputStream.read(actual));
        NullInputStreamTests.assertTrue((boolean)Arrays.equals(actual, expected));
    }

    public void testReadByteArrayIntInt() throws IOException {
        byte[] expected = new byte[10];
        Arrays.fill(expected, (byte)7);
        byte[] actual = new byte[10];
        Arrays.fill(actual, (byte)7);
        NullInputStreamTests.assertEquals((int)-1, (int)this.nullInputStream.read(actual, 2, 5));
        NullInputStreamTests.assertTrue((boolean)Arrays.equals(actual, expected));
    }

    public void testReset() {
        boolean exCaught = false;
        try {
            this.nullInputStream.reset();
        }
        catch (IOException iOException) {
            exCaught = true;
        }
        NullInputStreamTests.assertTrue((boolean)exCaught);
    }

    public void testSkip() throws IOException {
        NullInputStreamTests.assertEquals((long)0L, (long)this.nullInputStream.skip(5L));
    }
}

