/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.TightMap;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class TightMapTests
extends TestCase {
    private TightMap<String, String> map;

    public TightMapTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.map = this.buildMap();
    }

    private TightMap<String, String> buildMap() {
        TightMap m = new TightMap();
        this.populateMap((Map<? super String, ? super String>)m);
        return m;
    }

    private void populateMap(Map<? super String, ? super String> m) {
        m.put(null, "null");
        m.put("null", null);
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        m.put("4", "four");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testCtorMap() {
        HashMap map2 = new HashMap();
        this.map = new TightMap(map2);
        TightMapTests.assertEquals(this.map, map2);
    }

    public void testSize() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        this.map = new TightMap();
        TightMapTests.assertEquals((int)0, (int)this.map.size());
    }

    public void testIsEmpty() {
        TightMapTests.assertFalse((boolean)this.map.isEmpty());
        this.map = new TightMap();
        TightMapTests.assertTrue((boolean)this.map.isEmpty());
    }

    public void testContainsValue() {
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"null"));
        TightMapTests.assertTrue((boolean)this.map.containsValue(null));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"five"));
        this.map = new TightMap();
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"null"));
        TightMapTests.assertFalse((boolean)this.map.containsValue(null));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"five"));
    }

    public void testContainsKey() {
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"null"));
        TightMapTests.assertTrue((boolean)this.map.containsKey(null));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"two"));
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"five"));
        this.map = new TightMap();
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"null"));
        TightMapTests.assertFalse((boolean)this.map.containsKey(null));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"two"));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"five"));
    }

    public void testGet() {
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"null")));
        TightMapTests.assertEquals((String)"null", (String)((String)this.map.get(null)));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"two")));
        TightMapTests.assertEquals((String)"two", (String)((String)this.map.get((Object)"2")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"five")));
        this.map = new TightMap();
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"null")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get(null)));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"two")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"2")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"five")));
    }

    public void testPut() {
        TightMapTests.assertEquals(null, (String)((String)this.map.put((Object)"null", (Object)"seven")));
        TightMapTests.assertEquals((String)"seven", (String)((String)this.map.get((Object)"null")));
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"null"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"seven"));
        TightMapTests.assertEquals((String)"null", (String)((String)this.map.put(null, (Object)"eight")));
        TightMapTests.assertEquals((String)"eight", (String)((String)this.map.get(null)));
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey(null));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"eight"));
        TightMapTests.assertEquals(null, (String)((String)this.map.put((Object)"5", (Object)"five")));
        TightMapTests.assertEquals((String)"five", (String)((String)this.map.get((Object)"5")));
        TightMapTests.assertEquals((int)7, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"5"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"five"));
        this.map = new TightMap();
        TightMapTests.assertEquals(null, (String)((String)this.map.put((Object)"null", (Object)"seven")));
        TightMapTests.assertEquals((String)"seven", (String)((String)this.map.get((Object)"null")));
        TightMapTests.assertEquals((int)1, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"null"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"seven"));
        TightMapTests.assertEquals(null, (String)((String)this.map.put(null, (Object)"eight")));
        TightMapTests.assertEquals((String)"eight", (String)((String)this.map.get(null)));
        TightMapTests.assertEquals((int)2, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey(null));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"eight"));
        TightMapTests.assertEquals(null, (String)((String)this.map.put((Object)"5", (Object)"five")));
        TightMapTests.assertEquals((String)"five", (String)((String)this.map.get((Object)"5")));
        TightMapTests.assertEquals((int)3, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"5"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"five"));
    }

    public void testRemove() {
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"null")));
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"null"));
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsValue(null));
        TightMapTests.assertEquals(null, (String)((String)this.map.remove((Object)"null")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"null")));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"null"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
        TightMapTests.assertFalse((boolean)this.map.containsValue(null));
        TightMapTests.assertEquals((String)"null", (String)((String)this.map.get(null)));
        TightMapTests.assertTrue((boolean)this.map.containsKey(null));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"null"));
        TightMapTests.assertEquals((String)"null", (String)((String)this.map.remove(null)));
        TightMapTests.assertEquals(null, (String)((String)this.map.get(null)));
        TightMapTests.assertFalse((boolean)this.map.containsKey(null));
        TightMapTests.assertEquals((int)4, (int)this.map.size());
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"null"));
        TightMapTests.assertEquals((String)"three", (String)((String)this.map.get((Object)"3")));
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"3"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"three"));
        TightMapTests.assertEquals((String)"three", (String)((String)this.map.remove((Object)"3")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"3")));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"3"));
        TightMapTests.assertEquals((int)3, (int)this.map.size());
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"null"));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"7")));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"3"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"seven"));
        TightMapTests.assertEquals(null, (String)((String)this.map.remove((Object)"7")));
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"7")));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"7"));
        TightMapTests.assertEquals((int)3, (int)this.map.size());
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"seven"));
        TightMapTests.assertEquals((String)"one", (String)((String)this.map.remove((Object)"1")));
        TightMapTests.assertEquals((String)"two", (String)((String)this.map.remove((Object)"2")));
        TightMapTests.assertEquals((String)"four", (String)((String)this.map.remove((Object)"4")));
    }

    public void testPutAll() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("8", "eight");
        map2.put("9", "nine");
        map2.put("10", "ten");
        this.map.putAll(map2);
        TightMapTests.assertEquals((int)9, (int)this.map.size());
        TightMapTests.assertEquals((String)"eight", (String)((String)this.map.get((Object)"8")));
        TightMapTests.assertEquals((String)"nine", (String)((String)this.map.get((Object)"9")));
        TightMapTests.assertEquals((String)"ten", (String)((String)this.map.get((Object)"10")));
    }

    public void testPutAll_emptyMap() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        HashMap map2 = new HashMap();
        this.map.putAll(map2);
        TightMapTests.assertEquals((int)6, (int)this.map.size());
    }

    public void testClear() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"1"));
        TightMapTests.assertEquals((String)"one", (String)((String)this.map.get((Object)"1")));
        this.map.clear();
        TightMapTests.assertEquals((int)0, (int)this.map.size());
        TightMapTests.assertEquals(null, (String)((String)this.map.get((Object)"1")));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"1"));
    }

    public void testKeySet_iterator_hasNext() {
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        TightMapTests.assertEquals((int)6, (int)IteratorTools.size(keySet.iterator()));
    }

    public void testKeySet_iterator_next1() {
        Set keySet = this.map.keySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (String entry : map2.keySet()) {
            TightMapTests.assertTrue((boolean)IteratorTools.contains(keySet.iterator(), (Object)entry));
        }
    }

    public void testKeySet_iterator_next2() {
        Set keySet = this.map.keySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set keySet2 = map2.keySet();
        Iterator stream = keySet.iterator();
        while (stream.hasNext()) {
            keySet2.contains(stream.next());
        }
    }

    public void testKeySet_iterator_next_CME() {
        Set keySet = this.map.keySet();
        Iterator stream = keySet.iterator();
        this.map.remove((Object)"1");
        boolean exCaught = false;
        try {
            stream.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testKeySet_iterator_next_NSEE() {
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        int size = 0;
        Iterator stream = keySet.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++size;
        }
        TightMapTests.assertEquals((int)6, (int)size);
        boolean exCaught = false;
        try {
            stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testKeySet_iterator_remove1() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        Iterator stream = keySet.iterator();
        TightMapTests.assertTrue((boolean)stream.hasNext());
        String key = (String)stream.next();
        TightMapTests.assertEquals(null, (String)key);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        key = (String)stream.next();
        TightMapTests.assertEquals((String)"null", (String)key);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        key = (String)stream.next();
        TightMapTests.assertEquals((String)"1", (String)key);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        key = (String)stream.next();
        TightMapTests.assertEquals((String)"2", (String)key);
        stream.remove();
        TightMapTests.assertTrue((boolean)stream.hasNext());
        key = (String)stream.next();
        TightMapTests.assertEquals((String)"3", (String)key);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        key = (String)stream.next();
        TightMapTests.assertEquals((String)"4", (String)key);
        TightMapTests.assertFalse((boolean)stream.hasNext());
        TightMapTests.assertEquals((int)5, (int)keySet.size());
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
    }

    public void testKeySet_iterator_remove2() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        Iterator stream = keySet.iterator();
        while (stream.hasNext()) {
            String key = (String)stream.next();
            if (!ObjectTools.equals((Object)key, (Object)"2")) continue;
            stream.remove();
        }
        TightMapTests.assertEquals((int)5, (int)keySet.size());
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
    }

    public void testKeySet_iterator_remove_CME() {
        Set keySet = this.map.keySet();
        boolean exCaught = false;
        Iterator stream = keySet.iterator();
        while (stream.hasNext()) {
            String key = (String)stream.next();
            if (!ObjectTools.equals((Object)key, (Object)"2")) continue;
            this.map.remove((Object)"1");
            try {
                stream.remove();
                TightMapTests.fail();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                exCaught = true;
                break;
            }
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testKeySet_iterator_remove_ISE() {
        Set keySet = this.map.keySet();
        boolean exCaught = false;
        Iterator stream = keySet.iterator();
        while (stream.hasNext()) {
            String key = (String)stream.next();
            if (!ObjectTools.equals((Object)key, (Object)"2")) continue;
            stream.remove();
            try {
                stream.remove();
                TightMapTests.fail();
            }
            catch (IllegalStateException illegalStateException) {
                exCaught = true;
                break;
            }
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testKeySet_size() {
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
    }

    public void testKeySet_contains() {
        Set keySet = this.map.keySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (String entry : map2.keySet()) {
            TightMapTests.assertTrue((boolean)keySet.contains(entry));
        }
    }

    public void testKeySet_remove1() {
        Set keySet = this.map.keySet();
        TightMapTests.assertTrue((boolean)keySet.remove("2"));
        TightMapTests.assertFalse((boolean)keySet.contains("2"));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
    }

    public void testKeySet_remove2() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        TightMapTests.assertFalse((boolean)keySet.remove("88"));
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        TightMapTests.assertEquals((int)6, (int)this.map.size());
    }

    public void testKeySet_clear() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        Set keySet = this.map.keySet();
        TightMapTests.assertEquals((int)6, (int)keySet.size());
        keySet.clear();
        TightMapTests.assertEquals((int)0, (int)keySet.size());
        TightMapTests.assertEquals((int)0, (int)this.map.size());
    }

    public void testKeySet_equals() {
        Set keySet = this.map.keySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertTrue((boolean)keySet.equals(map2.keySet()));
        TightMapTests.assertTrue((boolean)map2.keySet().equals(keySet));
    }

    public void testKeySet_hashCode() {
        Set keySet = this.map.keySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertEquals((int)keySet.hashCode(), (int)map2.keySet().hashCode());
    }

    public void testKeySet_removeAll() {
        ArrayList<String> remove = new ArrayList<String>();
        remove.add(null);
        remove.add("1");
        Set keySet = this.map.keySet();
        TightMapTests.assertTrue((boolean)keySet.removeAll(remove));
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set keySet2 = map2.keySet();
        TightMapTests.assertTrue((boolean)keySet2.removeAll(remove));
        TightMapTests.assertEquals(keySet2, (Object)keySet);
    }

    public void testKeySet_add() {
        Set keySet = this.map.keySet();
        boolean exCaught = false;
        try {
            keySet.add("88");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testKeySet_addAll() {
        ArrayList<String> add = new ArrayList<String>();
        add.add(null);
        add.add("1");
        Set keySet = this.map.keySet();
        boolean exCaught = false;
        try {
            keySet.addAll(add);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testKeySet_containsAll() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(null);
        keys.add("1");
        Set keySet = this.map.keySet();
        TightMapTests.assertTrue((boolean)keySet.containsAll(keys));
    }

    public void testKeySet_isEmpty() {
        Set keySet = this.map.keySet();
        TightMapTests.assertFalse((boolean)keySet.isEmpty());
        keySet.clear();
        TightMapTests.assertTrue((boolean)keySet.isEmpty());
    }

    public void testKeySet_retainAll() {
        ArrayList<String> retain = new ArrayList<String>();
        retain.add(null);
        retain.add("1");
        Set keySet = this.map.keySet();
        TightMapTests.assertTrue((boolean)keySet.retainAll(retain));
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set keySet2 = map2.keySet();
        TightMapTests.assertTrue((boolean)keySet2.retainAll(retain));
        TightMapTests.assertEquals(keySet2, (Object)keySet);
    }

    public void testKeySet_toArray() {
        Set keySet = this.map.keySet();
        Object[] keys = keySet.toArray();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set keySet2 = map2.keySet();
        TightMapTests.assertEquals((int)keys.length, (int)keySet2.size());
        for (String entry : map2.keySet()) {
            TightMapTests.assertTrue((boolean)ArrayTools.contains((Object[])keys, (Object)entry));
        }
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            TightMapTests.assertTrue((boolean)keySet2.contains(key));
            ++n2;
        }
    }

    public void testKeySet_toArray2() {
        Set keySet = this.map.keySet();
        Object[] keys = keySet.toArray(StringTools.EMPTY_STRING_ARRAY);
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set keySet2 = map2.keySet();
        TightMapTests.assertEquals((int)keys.length, (int)keySet2.size());
        for (String entry : map2.keySet()) {
            TightMapTests.assertTrue((boolean)ArrayTools.contains((Object[])keys, (Object)entry));
        }
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            TightMapTests.assertTrue((boolean)keySet2.contains(key));
            ++n2;
        }
    }

    public void testKeySet_toString() {
        String expected = "[null, null, 1, 2, 3, 4]";
        TightMapTests.assertEquals((String)expected, (String)this.map.keySet().toString());
    }

    public void testValues_iterator_hasNext() {
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
        TightMapTests.assertEquals((int)6, (int)IteratorTools.size(values.iterator()));
    }

    public void testValues_iterator_next1() {
        Collection values = this.map.values();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (String entry : map2.values()) {
            TightMapTests.assertTrue((boolean)IteratorTools.contains(values.iterator(), (Object)entry));
        }
    }

    public void testValues_iterator_next2() {
        Collection values = this.map.values();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Collection values2 = map2.values();
        Iterator stream = values.iterator();
        while (stream.hasNext()) {
            values2.contains(stream.next());
        }
    }

    public void testValues_iterator_next_CME() {
        Collection values = this.map.values();
        Iterator stream = values.iterator();
        this.map.remove((Object)"1");
        boolean exCaught = false;
        try {
            stream.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testValues_iterator_next_NSEE() {
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
        int size = 0;
        Iterator stream = values.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++size;
        }
        TightMapTests.assertEquals((int)6, (int)size);
        boolean exCaught = false;
        try {
            stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testValues_iterator_remove1() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
        Iterator stream = values.iterator();
        TightMapTests.assertTrue((boolean)stream.hasNext());
        String value = (String)stream.next();
        TightMapTests.assertEquals((String)"null", (String)value);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        value = (String)stream.next();
        TightMapTests.assertEquals(null, (String)value);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        value = (String)stream.next();
        TightMapTests.assertEquals((String)"one", (String)value);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        value = (String)stream.next();
        TightMapTests.assertEquals((String)"two", (String)value);
        stream.remove();
        TightMapTests.assertTrue((boolean)stream.hasNext());
        value = (String)stream.next();
        TightMapTests.assertEquals((String)"three", (String)value);
        TightMapTests.assertTrue((boolean)stream.hasNext());
        value = (String)stream.next();
        TightMapTests.assertEquals((String)"four", (String)value);
        TightMapTests.assertFalse((boolean)stream.hasNext());
        TightMapTests.assertEquals((int)5, (int)values.size());
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
    }

    public void testValues_iterator_remove2() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
        Iterator stream = values.iterator();
        while (stream.hasNext()) {
            String value = (String)stream.next();
            if (!ObjectTools.equals((Object)value, (Object)"two")) continue;
            stream.remove();
        }
        TightMapTests.assertEquals((int)5, (int)values.size());
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
    }

    public void testValues_iterator_remove_CME() {
        Collection values = this.map.values();
        boolean exCaught = false;
        Iterator stream = values.iterator();
        while (stream.hasNext()) {
            String value = (String)stream.next();
            if (!ObjectTools.equals((Object)value, (Object)"two")) continue;
            this.map.remove((Object)"1");
            try {
                stream.remove();
                TightMapTests.fail();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                exCaught = true;
                break;
            }
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testValues_iterator_remove_ISE() {
        Collection values = this.map.values();
        boolean exCaught = false;
        Iterator stream = values.iterator();
        while (stream.hasNext()) {
            String value = (String)stream.next();
            if (!ObjectTools.equals((Object)value, (Object)"two")) continue;
            stream.remove();
            try {
                stream.remove();
                TightMapTests.fail();
            }
            catch (IllegalStateException illegalStateException) {
                exCaught = true;
                break;
            }
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testValues_size() {
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
    }

    public void testValues_contains() {
        Collection values = this.map.values();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (String entry : map2.values()) {
            TightMapTests.assertTrue((boolean)values.contains(entry));
        }
    }

    public void testValues_remove1() {
        Collection values = this.map.values();
        TightMapTests.assertTrue((boolean)values.remove("two"));
        TightMapTests.assertFalse((boolean)values.contains("two"));
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
    }

    public void testValues_remove2() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
        TightMapTests.assertFalse((boolean)values.remove("eleventy"));
        TightMapTests.assertEquals((int)6, (int)values.size());
        TightMapTests.assertEquals((int)6, (int)this.map.size());
    }

    public void testValues_clear() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        Collection values = this.map.values();
        TightMapTests.assertEquals((int)6, (int)values.size());
        values.clear();
        TightMapTests.assertEquals((int)0, (int)values.size());
        TightMapTests.assertEquals((int)0, (int)this.map.size());
    }

    public void testValues_equals() {
        Collection values = this.map.values();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertTrue((boolean)CollectionTools.hashBag((Iterable)values).equals((Object)CollectionTools.hashBag(map2.values())));
    }

    public void testValues_hashCode() {
        Collection values = this.map.values();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertEquals((int)CollectionTools.hashBag((Iterable)values).hashCode(), (int)CollectionTools.hashBag(map2.values()).hashCode());
    }

    public void testValues_removeAll() {
        ArrayList<String> remove = new ArrayList<String>();
        remove.add(null);
        remove.add("two");
        Collection values = this.map.values();
        TightMapTests.assertTrue((boolean)values.removeAll(remove));
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Collection values2 = map2.values();
        TightMapTests.assertTrue((boolean)values2.removeAll(remove));
        TightMapTests.assertEquals((Object)CollectionTools.hashBag(values2), (Object)CollectionTools.hashBag((Iterable)values));
    }

    public void testValues_add() {
        Collection values = this.map.values();
        boolean exCaught = false;
        try {
            values.add("eleventy");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testValues_addAll() {
        ArrayList<String> add = new ArrayList<String>();
        add.add(null);
        add.add("one");
        Collection values = this.map.values();
        boolean exCaught = false;
        try {
            values.addAll(add);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testValues_containsAll() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(null);
        strings.add("two");
        Collection values = this.map.values();
        TightMapTests.assertTrue((boolean)values.containsAll(strings));
    }

    public void testValues_isEmpty() {
        Collection values = this.map.values();
        TightMapTests.assertFalse((boolean)values.isEmpty());
        values.clear();
        TightMapTests.assertTrue((boolean)values.isEmpty());
    }

    public void testValues_retainAll() {
        ArrayList<String> retain = new ArrayList<String>();
        retain.add(null);
        retain.add("one");
        Collection values = this.map.values();
        TightMapTests.assertTrue((boolean)values.retainAll(retain));
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Collection values2 = map2.values();
        TightMapTests.assertTrue((boolean)values2.retainAll(retain));
        TightMapTests.assertEquals((Object)CollectionTools.hashBag(values2), (Object)CollectionTools.hashBag((Iterable)values));
    }

    public void testValues_toArray() {
        Collection values = this.map.values();
        Object[] strings = values.toArray();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Collection values2 = map2.values();
        TightMapTests.assertEquals((int)strings.length, (int)values2.size());
        for (String entry : map2.values()) {
            TightMapTests.assertTrue((boolean)ArrayTools.contains((Object[])strings, (Object)entry));
        }
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            TightMapTests.assertTrue((boolean)values2.contains(string));
            ++n2;
        }
    }

    public void testValues_toArray2() {
        Collection values = this.map.values();
        Object[] strings = values.toArray(StringTools.EMPTY_STRING_ARRAY);
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Collection values2 = map2.values();
        TightMapTests.assertEquals((int)strings.length, (int)values2.size());
        for (String entry : map2.values()) {
            TightMapTests.assertTrue((boolean)ArrayTools.contains((Object[])strings, (Object)entry));
        }
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            TightMapTests.assertTrue((boolean)values2.contains(string));
            ++n2;
        }
    }

    public void testValues_toString() {
        String expected = "[null, null, one, two, three, four]";
        TightMapTests.assertEquals((String)expected, (String)this.map.values().toString());
    }

    public void testEntrySet_iterator_hasNext() {
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        TightMapTests.assertEquals((int)6, (int)IteratorTools.size(entrySet.iterator()));
    }

    public void testEntrySet_iterator_next1() {
        Set entrySet = this.map.entrySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (Map.Entry entry : map2.entrySet()) {
            TightMapTests.assertTrue((boolean)IteratorTools.contains(entrySet.iterator(), entry));
        }
    }

    public void testEntrySet_iterator_next2() {
        Set entrySet = this.map.entrySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        Iterator stream = entrySet.iterator();
        while (stream.hasNext()) {
            entrySet2.contains(stream.next());
        }
    }

    public void testEntrySet_iterator_next_CME() {
        Set entrySet = this.map.entrySet();
        Iterator stream = entrySet.iterator();
        this.map.remove((Object)"1");
        boolean exCaught = false;
        try {
            stream.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testEntrySet_iterator_next_NSEE() {
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        int size = 0;
        Iterator stream = entrySet.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++size;
        }
        TightMapTests.assertEquals((int)6, (int)size);
        boolean exCaught = false;
        try {
            stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testEntrySet_iterator_remove1() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        Iterator stream = entrySet.iterator();
        TightMapTests.assertTrue((boolean)stream.hasNext());
        Map.Entry entry = (Map.Entry)stream.next();
        TightMapTests.assertEquals(null, (String)((String)entry.getKey()));
        TightMapTests.assertEquals((String)"null", (String)((String)entry.getValue()));
        TightMapTests.assertTrue((boolean)stream.hasNext());
        entry = (Map.Entry)stream.next();
        TightMapTests.assertEquals((String)"null", (String)((String)entry.getKey()));
        TightMapTests.assertEquals(null, (String)((String)entry.getValue()));
        TightMapTests.assertTrue((boolean)stream.hasNext());
        entry = (Map.Entry)stream.next();
        TightMapTests.assertEquals((String)"1", (String)((String)entry.getKey()));
        TightMapTests.assertEquals((String)"one", (String)((String)entry.getValue()));
        TightMapTests.assertTrue((boolean)stream.hasNext());
        entry = (Map.Entry)stream.next();
        TightMapTests.assertEquals((String)"2", (String)((String)entry.getKey()));
        TightMapTests.assertEquals((String)"two", (String)((String)entry.getValue()));
        stream.remove();
        TightMapTests.assertTrue((boolean)stream.hasNext());
        entry = (Map.Entry)stream.next();
        TightMapTests.assertEquals((String)"3", (String)((String)entry.getKey()));
        TightMapTests.assertEquals((String)"three", (String)((String)entry.getValue()));
        TightMapTests.assertTrue((boolean)stream.hasNext());
        entry = (Map.Entry)stream.next();
        TightMapTests.assertEquals((String)"4", (String)((String)entry.getKey()));
        TightMapTests.assertEquals((String)"four", (String)((String)entry.getValue()));
        TightMapTests.assertFalse((boolean)stream.hasNext());
        TightMapTests.assertEquals((int)5, (int)entrySet.size());
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
    }

    public void testEntrySet_iterator_remove2() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        Iterator stream = entrySet.iterator();
        while (stream.hasNext()) {
            Map.Entry entry = (Map.Entry)stream.next();
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            stream.remove();
        }
        TightMapTests.assertEquals((int)5, (int)entrySet.size());
        TightMapTests.assertFalse((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((int)5, (int)this.map.size());
    }

    public void testEntrySet_iterator_remove_CME() {
        Set entrySet = this.map.entrySet();
        boolean exCaught = false;
        Iterator stream = entrySet.iterator();
        while (stream.hasNext()) {
            Map.Entry entry = (Map.Entry)stream.next();
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            this.map.remove((Object)"1");
            try {
                stream.remove();
                TightMapTests.fail();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                exCaught = true;
                break;
            }
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testEntrySet_iterator_remove_ISE() {
        Set entrySet = this.map.entrySet();
        boolean exCaught = false;
        Iterator stream = entrySet.iterator();
        while (stream.hasNext()) {
            Map.Entry entry = (Map.Entry)stream.next();
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            stream.remove();
            try {
                stream.remove();
                TightMapTests.fail();
            }
            catch (IllegalStateException illegalStateException) {
                exCaught = true;
                break;
            }
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testEntrySet_iterator_entry_setValueObject() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        for (Map.Entry entry : entrySet) {
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            entry.setValue("XXX");
        }
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertFalse((boolean)this.map.containsValue((Object)"two"));
        TightMapTests.assertEquals((String)"XXX", (String)((String)this.map.get((Object)"2")));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"XXX"));
        TightMapTests.assertEquals((int)6, (int)this.map.size());
    }

    public void testEntrySet_iterator_entry_equalsObject() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        TightMapTests.assertTrue((boolean)this.map.containsKey((Object)"2"));
        TightMapTests.assertTrue((boolean)this.map.containsValue((Object)"two"));
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        for (Map.Entry entry : entrySet) {
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            TightMapTests.assertFalse((boolean)entry.equals("XXX"));
        }
    }

    public void testEntrySet_iterator_entry_equalsObject2() {
        TightMap map1 = new TightMap();
        map1.put("foo", "bar");
        TightMap map2 = new TightMap();
        map2.put("foo", "XXX");
        Set entrySet1 = map1.entrySet();
        Set entrySet2 = map2.entrySet();
        Map.Entry entry1 = entrySet1.iterator().next();
        Map.Entry entry2 = entrySet2.iterator().next();
        TightMapTests.assertFalse((boolean)entry1.equals(entry2));
    }

    public void testEntrySet_size() {
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
    }

    public void testEntrySet_contains1() {
        Set entrySet = this.map.entrySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (Map.Entry entry : map2.entrySet()) {
            TightMapTests.assertTrue((boolean)entrySet.contains(entry));
        }
    }

    public void testEntrySet_contains2() {
        Set entrySet = this.map.entrySet();
        HashMap<String, String> map2 = new HashMap<String, String>();
        this.populateMap(map2);
        map2.put("xxx", "XXX");
        for (Map.Entry entry : map2.entrySet()) {
            String key = (String)entry.getKey();
            if (key != null && key.equals("xxx")) {
                TightMapTests.assertFalse((boolean)entrySet.contains(entry));
                continue;
            }
            TightMapTests.assertTrue((boolean)entrySet.contains(entry));
        }
    }

    public void testEntrySet_contains3() {
        Set entrySet = this.map.entrySet();
        TightMapTests.assertFalse((boolean)entrySet.contains("XXX"));
    }

    public void testEntrySet_remove1() {
        Set entrySet = this.map.entrySet();
        Map.Entry remove = null;
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (Map.Entry entry : map2.entrySet()) {
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            remove = entry;
        }
        TightMapTests.assertTrue((boolean)entrySet.contains(remove));
        TightMapTests.assertTrue((boolean)this.map.containsKey(remove.getKey()));
        TightMapTests.assertTrue((boolean)this.map.containsValue(remove.getValue()));
        TightMapTests.assertTrue((boolean)entrySet.remove(remove));
        TightMapTests.assertFalse((boolean)entrySet.contains(remove));
        TightMapTests.assertFalse((boolean)this.map.containsKey(remove.getKey()));
        TightMapTests.assertFalse((boolean)this.map.containsValue(remove.getValue()));
    }

    public void testEntrySet_remove2() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        TightMapTests.assertFalse((boolean)entrySet.remove("eleventy"));
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        TightMapTests.assertEquals((int)6, (int)this.map.size());
    }

    public void testEntrySet_remove3() {
        TightMap map1 = new TightMap();
        Set entrySet1 = map1.entrySet();
        TightMap map2 = new TightMap();
        map2.put("foo", "FOO");
        Set entrySet2 = map2.entrySet();
        Map.Entry entry2 = entrySet2.iterator().next();
        TightMapTests.assertFalse((boolean)entrySet1.remove(entry2));
        map1.put("foo", "XXX");
        TightMapTests.assertFalse((boolean)entrySet1.remove(entry2));
    }

    public void testEntrySet_clear() {
        TightMapTests.assertEquals((int)6, (int)this.map.size());
        Set entrySet = this.map.entrySet();
        TightMapTests.assertEquals((int)6, (int)entrySet.size());
        entrySet.clear();
        TightMapTests.assertEquals((int)0, (int)entrySet.size());
        TightMapTests.assertEquals((int)0, (int)this.map.size());
    }

    public void testEntrySet_equals() {
        Set entrySet = this.map.entrySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertTrue((boolean)CollectionTools.hashBag((Iterable)entrySet).equals((Object)CollectionTools.hashBag(map2.entrySet())));
    }

    public void testEntrySet_hashCode() {
        Set entrySet = this.map.entrySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertEquals((int)CollectionTools.hashBag((Iterable)entrySet).hashCode(), (int)CollectionTools.hashBag(map2.entrySet()).hashCode());
    }

    public void testEntrySet_removeAll() {
        Set entrySet = this.map.entrySet();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        ArrayList remove = new ArrayList();
        for (Map.Entry entry : entrySet2) {
            if (ObjectTools.equals(entry.getKey(), null)) {
                remove.add(entry);
            }
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            remove.add(entry);
        }
        TightMapTests.assertTrue((boolean)entrySet.removeAll(remove));
        TightMapTests.assertTrue((boolean)entrySet2.removeAll(remove));
        TightMapTests.assertEquals((Object)CollectionTools.hashBag(entrySet2), (Object)CollectionTools.hashBag((Iterable)entrySet));
    }

    public void testEntrySet_add() {
        Map.Entry add = null;
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        for (Map.Entry entry : map2.entrySet()) {
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            add = entry;
        }
        Set entrySet = this.map.entrySet();
        boolean exCaught = false;
        try {
            entrySet.add(add);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testEntrySet_addAll() {
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        ArrayList add = new ArrayList();
        for (Map.Entry entry : entrySet2) {
            if (ObjectTools.equals(entry.getKey(), null)) {
                add.add(entry);
            }
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            add.add(entry);
        }
        Set entrySet = this.map.entrySet();
        boolean exCaught = false;
        try {
            entrySet.addAll(add);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TightMapTests.assertTrue((boolean)exCaught);
    }

    public void testEntrySet_containsAll() {
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        ArrayList strings = new ArrayList();
        for (Map.Entry entry : entrySet2) {
            if (ObjectTools.equals(entry.getKey(), null)) {
                strings.add(entry);
            }
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            strings.add(entry);
        }
        Set entrySet = this.map.entrySet();
        TightMapTests.assertTrue((boolean)entrySet.containsAll(strings));
    }

    public void testEntrySet_isEmpty() {
        Set entrySet = this.map.entrySet();
        TightMapTests.assertFalse((boolean)entrySet.isEmpty());
        entrySet.clear();
        TightMapTests.assertTrue((boolean)entrySet.isEmpty());
    }

    public void testEntrySet_retainAll() {
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        ArrayList retain = new ArrayList();
        for (Map.Entry entry : entrySet2) {
            if (ObjectTools.equals(entry.getKey(), null)) {
                retain.add(entry);
            }
            if (!ObjectTools.equals(entry.getKey(), (Object)"2")) continue;
            retain.add(entry);
        }
        Set entrySet = this.map.entrySet();
        TightMapTests.assertTrue((boolean)entrySet.retainAll(retain));
        TightMapTests.assertTrue((boolean)entrySet2.retainAll(retain));
        TightMapTests.assertEquals((Object)CollectionTools.hashBag(entrySet2), (Object)CollectionTools.hashBag((Iterable)entrySet));
    }

    public void testEntrySet_toArray() {
        Set entrySet = this.map.entrySet();
        Object[] strings = entrySet.toArray();
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        TightMapTests.assertEquals((int)strings.length, (int)entrySet2.size());
        for (Map.Entry entry : map2.entrySet()) {
            TightMapTests.assertTrue((boolean)ArrayTools.contains((Object[])strings, entry));
        }
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            TightMapTests.assertTrue((boolean)entrySet2.contains(string));
            ++n2;
        }
    }

    public void testEntrySet_toArray2() {
        Set entrySet = this.map.entrySet();
        Object[] entries = entrySet.toArray(new Map.Entry[0]);
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        Set entrySet2 = map2.entrySet();
        TightMapTests.assertEquals((int)entries.length, (int)entrySet2.size());
        for (Map.Entry entry : map2.entrySet()) {
            TightMapTests.assertTrue((boolean)ArrayTools.contains((Object[])entries, entry));
        }
        Object[] objectArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            TightMapTests.assertTrue((boolean)entrySet2.contains(object));
            ++n2;
        }
    }

    public void testEntrySet_toString() {
        String expected = "[null=null, null=null, 1=one, 2=two, 3=three, 4=four]";
        TightMapTests.assertEquals((String)expected, (String)this.map.entrySet().toString());
    }

    public void testEquals0() {
        TightMapTests.assertTrue((boolean)this.map.equals(this.map));
    }

    public void testEquals1() {
        TightMapTests.assertFalse((boolean)this.map.equals((Object)"map2"));
    }

    public void testEquals2() {
        HashMap map2 = new HashMap();
        TightMapTests.assertFalse((boolean)this.map.equals(map2));
    }

    public void testEquals3() {
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        map2.remove("1");
        TightMapTests.assertFalse((boolean)this.map.equals(map2));
    }

    public void testEquals4() {
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put(null, 0);
        map2.put("null", 0);
        map2.put("1", 1);
        map2.put("2", 2);
        map2.put("3", 3);
        map2.put("4", 4);
        TightMapTests.assertFalse((boolean)this.map.equals(map2));
    }

    public void testEquals5() {
        HashMap<Integer, String> map2 = new HashMap<Integer, String>();
        map2.put(0, null);
        map2.put(0, "null");
        map2.put(1, "1");
        map2.put(2, "2");
        map2.put(3, "3");
        map2.put(4, "4");
        TightMapTests.assertFalse((boolean)this.map.equals(map2));
    }

    public void testEquals6() {
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertTrue((boolean)this.map.equals(map2));
    }

    public void testEquals7() {
        TightMap map1 = new TightMap();
        map1.put((Object)"null", null);
        HashMap<String, String> map2 = new HashMap<String, String>();
        TightMapTests.assertFalse((boolean)map1.equals(map2));
        map2.put("null", "null");
        TightMapTests.assertFalse((boolean)map1.equals(map2));
        map2.put("null", null);
        TightMapTests.assertTrue((boolean)map1.equals(map2));
    }

    public void testHashCode1() {
        HashMap map2 = new HashMap();
        this.populateMap(map2);
        TightMapTests.assertEquals((int)this.map.hashCode(), (int)map2.hashCode());
    }

    public void testHashCode2() {
        LinkedHashMap map2 = new LinkedHashMap();
        this.populateMap(map2);
        TightMapTests.assertEquals((int)this.map.hashCode(), (int)map2.hashCode());
    }

    public void testToString1() {
        String expected = "{null=null, null=null, 1=one, 2=two, 3=three, 4=four}";
        TightMapTests.assertEquals((String)expected, (String)this.map.toString());
    }

    public void testToString2() {
        this.map.clear();
        String expected = "{}";
        TightMapTests.assertEquals((String)expected, (String)this.map.toString());
    }

    public void testToString3() {
        TightMap map2 = new TightMap();
        this.populateMap((Map<? super String, ? super String>)map2);
        map2.put((Object)map2, (Object)"this");
        String expected = "{null=null, null=null, 1=one, 2=two, 3=three, 4=four, (this Map)=this}";
        TightMapTests.assertEquals((String)expected, (String)map2.toString());
    }

    public void testToString4() {
        TightMap map2 = new TightMap();
        this.populateMap((Map<? super String, ? super String>)map2);
        map2.put((Object)"this", (Object)map2);
        String expected = "{null=null, null=null, 1=one, 2=two, 3=three, 4=four, this=(this Map)}";
        TightMapTests.assertEquals((String)expected, (String)map2.toString());
    }
}

