/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import org.eclipse.jpt.common.utility.internal.StringBufferTools;
import org.eclipse.jpt.common.utility.tests.internal.AbstractStringBuilderToolsTests;
import org.junit.Assert;

public class StringBufferToolsTests
extends AbstractStringBuilderToolsTests {
    public StringBufferToolsTests(String name) {
        super(name);
    }

    @Override
    protected void verifyConvertToCharArray(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append(string);
        Assert.assertArrayEquals((char[])string.toCharArray(), (char[])StringBufferTools.convertToCharArray((StringBuffer)sb));
    }

    @Override
    protected void verifyReverse(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.reverse((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.reverse((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyCenter(String expected, String s, int len) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.center((StringBuffer)sb, (String)s, (int)len);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.center((StringBuffer)sb, (char[])s.toCharArray(), (int)len);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyPad(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.pad((StringBuffer)sb, (String)string, (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.pad((StringBuffer)sb, (char[])string.toCharArray(), (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyFit(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.fit((StringBuffer)sb, (String)string, (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.fit((StringBuffer)sb, (char[])string.toCharArray(), (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyZeroPad(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.zeroPad((StringBuffer)sb, (String)string, (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.zeroPad((StringBuffer)sb, (char[])string.toCharArray(), (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyZeroFit(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.zeroFit((StringBuffer)sb, (String)string, (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.zeroFit((StringBuffer)sb, (char[])string.toCharArray(), (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRepeat(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.repeat((StringBuffer)sb, (String)string, (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.repeat((StringBuffer)sb, (char[])string.toCharArray(), (int)length);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifySeparate(String expected, String string, char separator, int segmentLength) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.separate((StringBuffer)sb, (String)string, (char)separator, (int)segmentLength);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.separate((StringBuffer)sb, (char[])string.toCharArray(), (char)separator, (int)segmentLength);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyDelimit(String expected, String string, String delimiter) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.delimit((StringBuffer)sb, (String)string, (String)delimiter);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.delimit((StringBuffer)sb, (char[])string.toCharArray(), (char[])delimiter.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyQuote(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.quote((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.quote((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveFirstOccurrence(String expected, String string, char charToRemove) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.removeFirstOccurrence((StringBuffer)sb, (String)string, (char)charToRemove);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.removeFirstOccurrence((StringBuffer)sb, (char[])string.toCharArray(), (char)charToRemove);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveAllOccurrences(String expected, String string, char charToRemove) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.removeAllOccurrences((StringBuffer)sb, (String)string, (char)charToRemove);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.removeAllOccurrences((StringBuffer)sb, (char[])string.toCharArray(), (char)charToRemove);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveAllSpaces(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.removeAllSpaces((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.removeAllSpaces((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveAllWhitespace(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.removeAllWhitespace((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.removeAllWhitespace((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyCompressWhitespace(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.compressWhitespace((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.compressWhitespace((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyCapitalize(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.capitalize((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.capitalize((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyUncapitalize(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.uncapitalize((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.uncapitalize((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToHexString(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToHexString((StringBuffer)sb, (byte[])string.getBytes());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertCamelCaseToAllCaps(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertCamelCaseToAllCaps((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertCamelCaseToAllCaps((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertCamelCaseToAllCapsMaxLength(String expected, String string, int maxLength) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertCamelCaseToAllCaps((StringBuffer)sb, (String)string, (int)maxLength);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertCamelCaseToAllCaps((StringBuffer)sb, (char[])string.toCharArray(), (int)maxLength);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertAllCapsToCamelCase((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertAllCapsToCamelCase((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string, boolean capFirst) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertAllCapsToCamelCase((StringBuffer)sb, (String)string, (boolean)capFirst);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertAllCapsToCamelCase((StringBuffer)sb, (char[])string.toCharArray(), (boolean)capFirst);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyUndelimit(String expected, String s) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.undelimit((StringBuffer)sb, (String)s);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.undelimit((StringBuffer)sb, (char[])s.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyUndelimitCount(String expected, String s, int count) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.undelimit((StringBuffer)sb, (String)s, (int)count);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.undelimit((StringBuffer)sb, (char[])s.toCharArray(), (int)count);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToJavaStringLiteral(String expected, String s) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToJavaStringLiteral((StringBuffer)sb, (String)s);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToJavaStringLiteral((StringBuffer)sb, (char[])s.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToJavaStringLiteralContent(String expected, String s) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToJavaStringLiteralContent((StringBuffer)sb, (String)s);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToJavaStringLiteralContent((StringBuffer)sb, (char[])s.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlAttributeValue(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToXmlAttributeValue((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToXmlAttributeValue((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValue(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToDoubleQuotedXmlAttributeValue((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToDoubleQuotedXmlAttributeValue((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValueContent(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValue(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToSingleQuotedXmlAttributeValue((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToSingleQuotedXmlAttributeValue((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValueContent(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToSingleQuotedXmlAttributeValueContent((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToSingleQuotedXmlAttributeValueContent((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlElementText(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToXmlElementText((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToXmlElementText((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlElementCDATA(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToXmlElementCDATA((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToXmlElementCDATA((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlElementCDATAContent(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringBufferTools.convertToXmlElementCDATAContent((StringBuffer)sb, (String)string);
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringBufferTools.convertToXmlElementCDATAContent((StringBuffer)sb, (char[])string.toCharArray());
        StringBufferToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected Class<?> getToolsClass() {
        return StringBufferTools.class;
    }
}

