/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.RepeatingElementList;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class ObjectToolsTests
extends TestCase {
    public static final Transformer<Class<?>, Class<?>> SUPERCLASS_TRANSFORMER = new SuperClassTransformer();
    public String baz;

    public ObjectToolsTests(String name) {
        super(name);
    }

    public void testEquals1() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.equals(null, null));
    }

    public void testEquals2() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.equals(null, (Object)"foo"));
    }

    public void testEquals3() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.equals((Object)"foo", null));
    }

    public void testEquals4() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.equals((Object)"foo", (Object)"foo"));
    }

    public void testEquals5() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.equals((Object)"foo", (Object)"bar"));
    }

    public void testNotEquals1() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.notEquals(null, null));
    }

    public void testNotEquals2() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.notEquals(null, (Object)"foo"));
    }

    public void testNotEquals3() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.notEquals((Object)"foo", null));
    }

    public void testNotEquals4() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.notEquals((Object)"foo", (Object)"foo"));
    }

    public void testNotEquals5() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.notEquals((Object)"foo", (Object)"bar"));
    }

    public void testHashCode() {
        Object o = null;
        ObjectToolsTests.assertEquals((int)0, (int)ObjectTools.hashCode(o));
        o = new Object();
        ObjectToolsTests.assertEquals((int)o.hashCode(), (int)ObjectTools.hashCode((Object)o));
    }

    public void testHashCodeNull() {
        Object o = null;
        ObjectToolsTests.assertEquals((int)-1, (int)ObjectTools.hashCode(o, (int)-1));
    }

    public void testChain() {
        Iterable classes = ObjectTools.chain(Vector.class, SUPERCLASS_TRANSFORMER);
        ObjectToolsTests.assertEquals((int)4, (int)IterableTools.size((Iterable)classes));
    }

    public void testRepeat() {
        String s = "foo";
        RepeatingElementList strings = ObjectTools.repeat((Object)s, (int)3);
        ObjectToolsTests.assertEquals((int)3, (int)strings.size());
        ObjectToolsTests.assertEquals((String)s, (String)((String)strings.get(0)));
        ObjectToolsTests.assertEquals((String)s, (String)((String)strings.get(1)));
        ObjectToolsTests.assertEquals((String)s, (String)((String)strings.get(2)));
    }

    public void testToStringObjectObject() {
        String s = ObjectTools.toString((Object)((Object)this), Arrays.asList("foo", "bar"));
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("([foo, bar])"));
    }

    public void testToStringObjectObjectArray() {
        String s = ObjectTools.toString((Object)((Object)this), (Object[])new Object[]{"foo", "bar"});
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("([foo, bar])"));
    }

    public void testToStringObjectBoolean() {
        String s = ObjectTools.toString((Object)((Object)this), (boolean)false);
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(false)"));
    }

    public void testToStringObjectChar() {
        String s = ObjectTools.toString((Object)((Object)this), (char)'x');
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(x)"));
    }

    public void testToStringObjectCharArray() {
        String s = ObjectTools.toString((Object)((Object)this), (char[])"foo".toCharArray());
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(foo)"));
    }

    public void testToStringObjectCharSequence() {
        String s = ObjectTools.toString((Object)((Object)this), (CharSequence)"foo");
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(foo)"));
    }

    public void testToStringObjectDouble() {
        String s = ObjectTools.toString((Object)((Object)this), (double)77.77);
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(77.77)"));
    }

    public void testToStringObjectFloat() {
        String s = ObjectTools.toString((Object)((Object)this), (float)77.77f);
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(77.77)"));
    }

    public void testToStringObjectInt() {
        String s = ObjectTools.toString((Object)((Object)this), (int)77);
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(77)"));
    }

    public void testToStringObjectLong() {
        String s = ObjectTools.toString((Object)((Object)this), (long)77L);
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("(77)"));
    }

    public void testToStringObject() {
        String s = ObjectTools.toString((Object)((Object)this));
        ObjectToolsTests.assertTrue((boolean)s.startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        ObjectToolsTests.assertTrue((boolean)s.endsWith("]"));
    }

    public void testIdentityToStringObject() {
        Object o = new Object();
        ObjectToolsTests.assertEquals((String)o.toString(), (String)ObjectTools.identityToString((Object)o));
    }

    public void testSingletonToStringObject() {
        ObjectToolsTests.assertEquals((String)((Object)((Object)this)).getClass().getSimpleName(), (String)ObjectTools.singletonToString((Object)((Object)this)));
    }

    public void testToStringName_anonymous() {
        Object o = new Object(){};
        ObjectToolsTests.assertEquals((String)"Object", (String)ClassTools.toStringName(o.getClass()));
    }

    public void testToStringName_member() {
        ObjectToolsTests.assertEquals((String)"Map.Entry", (String)ClassTools.toStringName(Map.Entry.class));
    }

    public void testToStringName_local() {
        class Foo {
            1Foo.Bar bar = new 1Foo.Bar();

            Foo() {
            }

            class 1Foo.Bar {
                1Foo.Bar() {
                }
            }
        }
        Foo foo = new Foo();
        ObjectToolsTests.assertEquals((String)"ObjectToolsTests.Foo", (String)ClassTools.toStringName(foo.getClass()));
        ObjectToolsTests.assertEquals((String)"ObjectToolsTests.Foo.Bar", (String)ClassTools.toStringName(foo.bar.getClass()));
    }

    public void testGet() {
        int initialCapacity = 200;
        Vector v = new Vector(initialCapacity);
        Object[] elementData = (Object[])ObjectTools.get(v, (String)"elementData");
        ObjectToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
        Integer modCountInteger = (Integer)ObjectTools.get(v, (String)"modCount");
        int modCount = modCountInteger;
        ObjectToolsTests.assertEquals((int)0, (int)modCount);
    }

    public void testGet_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object value = ObjectTools.get(new Vector(), (String)"bogusField");
                ObjectToolsTests.fail((String)("bogus: " + value));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((boolean)exCaught);
    }

    public void testSet() {
        Vector v = new Vector();
        Object[] newElementData = new Object[5];
        newElementData[0] = "foo";
        ObjectTools.set(v, (String)"elementData", (Object)newElementData);
        ObjectTools.set(v, (String)"elementCount", (Object)new Integer(1));
        ObjectTools.set(v, (String)"modCount", (Object)new Integer(1));
        ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
    }

    public void testSet_exception() {
        boolean exCaught;
        block2: {
            Vector v = new Vector();
            Object[] newElementData = new Object[5];
            newElementData[0] = "foo";
            exCaught = false;
            try {
                ObjectTools.set(v, (String)"bogusField", (Object)"foo");
                ObjectToolsTests.fail();
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((boolean)exCaught);
    }

    public void testField() {
        ObjectToolsTests.assertNotNull((Object)ObjectTools.field((Object)((Object)this), (String)"baz"));
    }

    public void testField_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Field field = ObjectTools.field((Object)((Object)this), (String)"BOGUS");
                ObjectToolsTests.fail((String)("bogus: " + field));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((boolean)exCaught);
    }

    public void testExecuteObjectString() {
        Vector<String> v = new Vector<String>();
        int size = (Integer)ObjectTools.execute(v, (String)"size");
        ObjectToolsTests.assertEquals((int)0, (int)size);
        v.addElement("foo");
        size = (Integer)ObjectTools.execute(v, (String)"size");
        ObjectToolsTests.assertEquals((int)1, (int)size);
    }

    public void testExecuteObjectString_() throws Exception {
        Vector<String> v = new Vector<String>();
        int size = (Integer)ObjectTools.execute_(v, (String)"size");
        ObjectToolsTests.assertEquals((int)0, (int)size);
        v.addElement("foo");
        size = (Integer)ObjectTools.execute(v, (String)"size");
        ObjectToolsTests.assertEquals((int)1, (int)size);
    }

    public void testExecuteObjectStringClassObject() {
        Vector v = new Vector();
        boolean booleanResult = (Boolean)ObjectTools.execute(v, (String)"add", Object.class, (Object)"foo");
        ObjectToolsTests.assertTrue((boolean)booleanResult);
        ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
        Object voidResult = ObjectTools.execute(v, (String)"addElement", Object.class, (Object)"bar");
        ObjectToolsTests.assertNull((Object)voidResult);
    }

    public void testExecuteObjectStringClassObject_() throws Exception {
        Vector v = new Vector();
        boolean booleanResult = (Boolean)ObjectTools.execute_(v, (String)"add", Object.class, (Object)"foo");
        ObjectToolsTests.assertTrue((boolean)booleanResult);
        ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
        Object voidResult = ObjectTools.execute(v, (String)"addElement", Object.class, (Object)"bar");
        ObjectToolsTests.assertNull((Object)voidResult);
    }

    public void testExecuteObjectStringClassArrayObjectArray() {
        Vector v = new Vector();
        Class[] parmTypes = new Class[]{Object.class};
        Object[] args = new Object[]{"foo"};
        boolean booleanResult = (Boolean)ObjectTools.execute(v, (String)"add", (Class[])parmTypes, (Object[])args);
        ObjectToolsTests.assertTrue((boolean)booleanResult);
        ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
    }

    public void testExecuteObjectStringClassArrayObjectArray_exception() {
        boolean exCaught;
        block2: {
            Vector v = new Vector();
            Class[] parmTypes = new Class[]{Object.class};
            Object[] args = new Object[]{"foo"};
            exCaught = false;
            try {
                Object value = ObjectTools.execute(v, (String)"bogusMethod", (Class[])parmTypes, (Object[])args);
                ObjectToolsTests.fail((String)("bogus: " + value));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((boolean)exCaught);
    }

    public void testMethod() {
        ObjectToolsTests.assertNotNull((Object)ObjectTools.method((Object)((Object)this), (String)"testMethod"));
    }

    public void testMethod_() throws Exception {
        ObjectToolsTests.assertNotNull((Object)ObjectTools.method_((Object)((Object)this), (String)"testMethod"));
    }

    public void testMethodWithParm() {
        ObjectToolsTests.assertNotNull((Object)ObjectTools.method((Object)((Object)this), (String)"methodWithParm", String.class));
    }

    public void testMethodWithParm_() throws Exception {
        ObjectToolsTests.assertNotNull((Object)ObjectTools.method_((Object)((Object)this), (String)"methodWithParm", String.class));
    }

    public void methodWithParm(String string) {
        ObjectToolsTests.assertNotNull((Object)string);
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(ObjectTools.class);
                ObjectToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((boolean)exCaught);
    }

    static class SuperClassTransformer
    extends TransformerAdapter<Class<?>, Class<?>> {
        SuperClassTransformer() {
        }

        public Class<?> transform(Class<?> input) {
            return input.getSuperclass();
        }
    }
}

