/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class GetSourceTests
extends ModifyingResourceTests {
    IJavaScriptUnit cu;

    public GetSourceTests(String name) {
        super(name);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P");
        this.createFolder("/P/p");
        this.createFile("/P/p/X.js", "package p;\nimport java.lang.*;\npublic class X {\n  public Object field;\n  private int s\\u0069ze;\n  void foo(String s) {\n    final int var1 = 2;\n    Object var2;\n    for (int i = 0;  i < 10; i++) {}\n  }\n  private int bar() {\n    return 1;\n  }\n  /**\n   * Returns the size.\n   * @return\n   *     the size\n   */\n  int getSiz\\u0065 () {\n    return this.size;\n  }\n}");
        this.cu = this.getCompilationUnit("/P/p/X.js");
        String cuSource = "package p;\npublic class Constants {\n  static final long field1 = 938245798324893L;\n  static final long field2 = 938245798324893l;\n  static final long field3 = 938245798324893;\n  static final char field4 = ' ';\n  static final double field5 = 938245798324893D;\n  static final float field6 = 123456f;\n  static final int field7 = 1<<0;\n}";
        this.createFile("/P/p/Constants.js", cuSource);
    }

    public static Test suite() {
        return GetSourceTests.buildModelTestSuite(GetSourceTests.class);
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    public void testField() throws JavaScriptModelException {
        IType type = this.cu.getType("X");
        IField field = type.getField("field");
        String actualSource = field.getSource();
        String expectedSource = "public Object field;";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testImport() throws JavaScriptModelException {
        IImportDeclaration i = this.cu.getImport("java.lang.*");
        String actualSource = i.getSource();
        String expectedSource = "import java.lang.*;";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testLocalVariable1() throws JavaScriptModelException {
        ILocalVariable var = this.getLocalVariable("/P/p/X.js", "var1 = 2;", "var1");
        String actualSource = var.getSource();
        String expectedSource = "final int var1 = 2;";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testLocalVariable2() throws JavaScriptModelException {
        ILocalVariable var = this.getLocalVariable("/P/p/X.js", "var2;", "var2");
        String actualSource = var.getSource();
        String expectedSource = "Object var2;";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testLocalVariable3() throws JavaScriptModelException {
        ILocalVariable var = this.getLocalVariable("/P/p/X.js", "i = 0;", "i");
        String actualSource = var.getSource();
        String expectedSource = "int i = 0";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testLocalVariable4() throws JavaScriptModelException {
        ILocalVariable var = this.getLocalVariable("/P/p/X.js", "s) {", "s");
        String actualSource = var.getSource();
        String expectedSource = "String s";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testMethod() throws JavaScriptModelException {
        IType type = this.cu.getType("X");
        IFunction method = type.getFunction("bar", new String[0]);
        String actualSource = method.getSource();
        String expectedSource = "private int bar() {\n    return 1;\n  }";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testNameRangeMethodWithSyntaxError() throws CoreException {
        try {
            String cuSource = "package p;\npublic class Y {\n  void foo() {\n  }\n  void static bar() {}\n}";
            this.createFile("/P/p/Y.js", cuSource);
            IFunction method = this.getCompilationUnit("/P/p/Y.js").getType("Y").getFunction("bar", new String[0]);
            String actualSource = this.getNameSource(cuSource, (IJavaScriptElement)method);
            String expectedSource = "bar";
            this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
        }
        finally {
            this.deleteFile("/P/p/Y.js");
        }
    }

    public void testNameRangeAnonymous() throws CoreException {
        try {
            String cuSource = "package p;\npublic class Y {\n  void foo() {\n    Y y = new Y() {};\n    class C {\n    }\n  }\n}";
            this.createFile("/P/p/Y.js", cuSource);
            IType anonymous = this.getCompilationUnit("/P/p/Y.js").getType("Y").getFunction("foo", new String[0]).getType("", 1);
            String actualSource = this.getNameSource(cuSource, (IJavaScriptElement)anonymous);
            String expectedSource = "Y";
            this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
        }
        finally {
            this.deleteFile("/P/p/Y.js");
        }
    }

    public void testUnicodeField() throws JavaScriptModelException {
        IType type = this.cu.getType("X");
        IField field = type.getField("size");
        String actualSource = field.getSource();
        String expectedSource = "private int s\\u0069ze;";
        this.assertSourceEquals("Unexpected source'", expectedSource, actualSource);
    }

    public void testUnicodeMethod() throws JavaScriptModelException {
        IType type = this.cu.getType("X");
        IFunction method = type.getFunction("getSize", null);
        String actualSource = method.getSource();
        String expectedSource = "/**\n   * Returns the size.\n   * @return\n   *     the size\n   */\n  int getSiz\\u0065 () {\n    return this.size;\n  }";
        this.assertSourceEquals("Unexpected source", expectedSource, actualSource);
    }

    private IField getConstantField(String fieldName) {
        IType type = this.getCompilationUnit("/P/p/Constants.js").getType("Constants");
        IField field = type.getField(fieldName);
        return field;
    }
}

