/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestAttributesOrder
extends TestCase {
    private boolean isSetup = false;
    private final String fProjectName = "AttributesOrder";
    private final String fZipFileName = "attributesordertestfiles.zip";

    public TestAttributesOrder() {
        super("TestAttributesOrder");
    }

    public void testIgnoresAttributesOrder() throws IOException, CoreException {
        IFile file = this.getFile("PreviouslySucceedingTest.xml");
        this.ensureDocumentHasGrammar(file);
        file = this.getFile("PreviouslyFailingTest.xml");
        this.ensureDocumentHasGrammar(file);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "attributesordertestfiles.zip", "projecttestfiles");
        URL platformLocationURL = platformLocation.getURL();
        String file = platformLocationURL.getFile();
        unzipUtil.unzipAndImport(zipFile, file);
        unzipUtil.initJavaProject("AttributesOrder");
    }

    private void ensureDocumentHasGrammar(IFile file) throws IOException, CoreException {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForRead(file);
            TestAttributesOrder.assertNotNull((String)"failure loading model", (Object)model);
            IDOMModel domModel = (IDOMModel)model;
            IDOMDocument document = domModel.getDocument();
            TestAttributesOrder.assertNotNull((String)"failure getting document", (Object)document);
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
            TestAttributesOrder.assertNotNull((String)"ModelQuery is missing", (Object)modelQuery);
            IDOMElement documentElement = (IDOMElement)document.getDocumentElement();
            TestAttributesOrder.assertNotNull((String)"missing document element", (Object)documentElement);
            CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)documentElement);
            TestAttributesOrder.assertNotNull((String)("No element declaration for" + documentElement.getNodeName() + " (" + documentElement.getNamespaceURI() + ")"), (Object)cmElementDeclaration);
            TestAttributesOrder.assertNotNull((String)("No content assist available for" + documentElement.getNodeName() + " (" + documentElement.getNamespaceURI() + ")"), (Object)modelQuery.getAvailableContent((Element)documentElement, cmElementDeclaration, 2));
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private IFile getFile(String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path path = new Path("AttributesOrder/" + fileName);
        return root.getFile((IPath)path);
    }
}

