/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.util;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMRuntimeManager;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.Dom2ResourceMapper;
import org.eclipse.jst.ws.jaxws.testutils.dom.WaitingDomUtil;
import org.eclipse.jst.ws.jaxws.testutils.project.TestEjb3Project;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;

public class Dom2ResourceMapperTest
extends TestCase {
    private Dom2ResourceMapper mapper = Dom2ResourceMapper.INSTANCE;
    private TestProject testProject;
    private TestProject testProject1;
    private IType seiType;
    private IType wsType;
    private IDOM dom;
    private DomUtil domUtil;

    public void setUp() throws Exception {
        this.domUtil = new WaitingDomUtil();
        this.testProject = this.prepareProject();
        IPackageFragment pck = this.testProject.createPackage("test");
        this.seiType = this.testProject.createType(pck, "Sei.java", "@javax.jws.WebService public interface Sei { \n@javax.jws.WebMethod public void test(int a); \n}");
        this.testProject1 = this.prepareProject();
        pck = this.testProject1.createPackage("test");
        this.wsType = this.testProject1.createType(pck, "Ws.java", "@javax.jws.WebService public class Ws {}");
        IWsDOMRuntimeExtension domRuntime = WsDOMRuntimeManager.instance().getDOMRuntime("org.eclipse.jst.ws.jaxws.dom.jee5");
        domRuntime.createDOM(null);
        this.dom = domRuntime.getDOM();
    }

    private TestProject prepareProject() throws Exception {
        TestEjb3Project tp = new TestEjb3Project("Ejb");
        return new TestProject(tp.getProject());
    }

    public void tearDown() {
        try {
            this.testProject.dispose();
        }
        catch (Exception exception) {}
        try {
            this.testProject1.dispose();
        }
        catch (Exception exception) {}
    }

    public void testFindProject() {
        IWebServiceProject wsProject = this.domUtil.findProjectByName(this.dom, this.testProject.getProject().getName());
        IProject project = this.mapper.findProject(wsProject);
        Dom2ResourceMapperTest.assertEquals((Object)this.testProject.getProject(), (Object)project);
    }

    public void testFindResourceSei() throws JavaModelException {
        IWebServiceProject wsProject = this.domUtil.findProjectByName(this.dom, this.testProject.getProject().getName());
        IServiceEndpointInterface sei = this.domUtil.findSeiByImplName(wsProject, "test.Sei");
        Dom2ResourceMapperTest.assertNotNull((Object)sei);
        IType type = this.mapper.findType((EObject)sei);
        Dom2ResourceMapperTest.assertNotNull((Object)type);
        Dom2ResourceMapperTest.assertEquals((Object)this.seiType, (Object)type);
    }

    public void testFindResourceWs() throws JavaModelException {
        IWebServiceProject wsProject = this.domUtil.findProjectByName(this.dom, this.testProject1.getProject().getName());
        IWebService ws = this.domUtil.findWsByImplName(wsProject, "test.Ws");
        Dom2ResourceMapperTest.assertNotNull((Object)ws);
        IType type = this.mapper.findType((EObject)ws);
        Dom2ResourceMapperTest.assertNotNull((Object)type);
        Dom2ResourceMapperTest.assertEquals((Object)this.wsType, (Object)type);
    }

    public void testFindResourceWebMethod() throws JavaModelException {
        IWebServiceProject wsProject = this.domUtil.findProjectByName(this.dom, this.testProject.getProject().getName());
        IServiceEndpointInterface sei = this.domUtil.findSeiByImplName(wsProject, "test.Sei");
        Dom2ResourceMapperTest.assertNotNull((Object)sei);
        IType type = this.mapper.findType((EObject)sei.getWebMethods().get(0));
        Dom2ResourceMapperTest.assertNotNull((Object)type);
        Dom2ResourceMapperTest.assertEquals((Object)this.seiType, (Object)type);
        IWebMethod webMethod = DomFactory.eINSTANCE.createIWebMethod();
        type = this.mapper.findType((EObject)webMethod);
        Dom2ResourceMapperTest.assertNull((Object)type);
    }

    public void testFindResourceWebParam() throws JavaModelException {
        IWebServiceProject wsProject = this.domUtil.findProjectByName(this.dom, this.testProject.getProject().getName());
        IServiceEndpointInterface sei = this.domUtil.findSeiByImplName(wsProject, "test.Sei");
        Dom2ResourceMapperTest.assertNotNull((Object)sei);
        IType type = this.mapper.findType((EObject)((IWebMethod)sei.getWebMethods().get(0)).getParameters().get(0));
        Dom2ResourceMapperTest.assertNotNull((Object)type);
        Dom2ResourceMapperTest.assertEquals((Object)this.seiType, (Object)type);
    }
}

