/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.jws.WebParam;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class AddAnnotationToMethodParameterTest
extends AbstractAnnotationTest {
    @Override
    public String getPackageName() {
        return "com.example";
    }

    @Override
    public String getClassName() {
        return "Calculator.java";
    }

    @Override
    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    @Override
    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (String)"i");
        memberValuePairs.add(nameValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebParam.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToMethodParameter() {
        try {
            AddAnnotationToMethodParameterTest.assertNotNull((Object)this.annotation);
            AddAnnotationToMethodParameterTest.assertEquals((String)WebParam.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("add", new String[]{"I", "I"});
            AddAnnotationToMethodParameterTest.assertNotNull((Object)method);
            ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)method, (String)"i");
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)localVariable, (String)WebParam.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)localVariable, (Annotation)this.annotation));
            AddAnnotationToMethodParameterTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToMethodParameterTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)localVariable, (Annotation)this.annotation));
            AddAnnotationToMethodParameterTest.assertTrue((boolean)this.source.getImport(WebParam.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            AddAnnotationToMethodParameterTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

