/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.internal.Injection;

public class InjectionPlan {
    private final List<Field> testSubjectFields = new ArrayList<Field>(1);
    private final List<Injection> qualifiedInjections = new ArrayList<Injection>(5);
    private final List<Injection> unqualifiedInjections = new ArrayList<Injection>(5);
    private final Set<String> qualifiers = new HashSet<String>();

    public void addInjection(Injection injection) {
        String qualifier = injection.getAnnotation().fieldName();
        if (qualifier.length() != 0) {
            this.blockDuplicateQualifiers(qualifier);
            this.qualifiedInjections.add(injection);
        } else {
            this.unqualifiedInjections.add(injection);
        }
    }

    private void blockDuplicateQualifiers(String qualifier) {
        if (!this.qualifiers.add(qualifier)) {
            throw new AssertionError((Object)String.format("At least two mocks have fieldName qualifier '%s'", qualifier));
        }
    }

    public void addTestSubjectField(Field f) {
        this.testSubjectFields.add(f);
    }

    public List<Field> getTestSubjectFields() {
        return this.testSubjectFields;
    }

    public List<Injection> getQualifiedInjections() {
        return this.qualifiedInjections;
    }

    public List<Injection> getUnqualifiedInjections() {
        return this.unqualifiedInjections;
    }
}

