/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MockResourceDelta
implements IResourceDelta {
    private final IResource _afterEventResource;
    private final IResource _beforeEventResource;
    private final List<MockResourceDelta> _childDeltas;
    private final int _status;
    protected static int KIND_MASK = 255;

    public MockResourceDelta(IResource afterEventResource, IResource beforeEventResource, int status, List<MockResourceDelta> childDeltas) {
        if (afterEventResource == null && beforeEventResource == null) {
            throw new IllegalArgumentException();
        }
        this._afterEventResource = afterEventResource;
        this._beforeEventResource = beforeEventResource;
        this._status = status;
        this._childDeltas = childDeltas;
    }

    public MockResourceDelta merge(MockResourceDelta delta) {
        ArrayList<MockResourceDelta> mergedChildren = new ArrayList<MockResourceDelta>(this._childDeltas);
        for (MockResourceDelta mergeMe : delta._childDeltas) {
            Iterator it = mergedChildren.iterator();
            while (it.hasNext()) {
                if (!((MockResourceDelta)it.next()).getActiveResource().equals((Object)mergeMe.getActiveResource())) continue;
                it.remove();
            }
            mergedChildren.add(mergeMe);
        }
        return new MockResourceDelta(delta._afterEventResource, delta._beforeEventResource, delta._status, mergedChildren);
    }

    public void accept(IResourceDeltaVisitor visitor) throws CoreException {
        this.accept(visitor, 0);
    }

    public void accept(IResourceDeltaVisitor visitor, boolean includePhantoms) throws CoreException {
        this.accept(visitor, includePhantoms ? 1 : 0);
    }

    public void accept(IResourceDeltaVisitor visitor, int memberFlags) throws CoreException {
        boolean includeHidden;
        boolean includePhantoms = (memberFlags & 1) != 0;
        boolean includeTeamPrivate = (memberFlags & 2) != 0;
        boolean bl = includeHidden = (memberFlags & 8) != 0;
        if (!visitor.visit((IResourceDelta)this)) {
            return;
        }
        for (MockResourceDelta childDelta : this._childDeltas) {
            if (!includeTeamPrivate && childDelta.isTeamPrivate() || !includePhantoms && childDelta.isPhantom() || !includeHidden && childDelta.isHidden()) continue;
            childDelta.accept(visitor, memberFlags);
        }
    }

    public IResourceDelta findMember(IPath path) {
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return this;
        }
        MockResourceDelta current = this;
        int i = 0;
        while (i < segmentCount) {
            int j;
            List<MockResourceDelta> currentChildren;
            block4: {
                currentChildren = current._childDeltas;
                j = 0;
                int jmax = currentChildren.size();
                while (j < jmax) {
                    if (!currentChildren.get(j).getFullPath().lastSegment().equals(path.segment(i))) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            current = currentChildren.get(j);
            ++i;
        }
        return current;
    }

    public IResourceDelta[] getAffectedChildren() {
        return this.getAffectedChildren(7, 0);
    }

    public IResourceDelta[] getAffectedChildren(int kindMask) {
        return this.getAffectedChildren(kindMask, 0);
    }

    public IResourceDelta[] getAffectedChildren(int kindMask, int memberFlags) {
        boolean includeHidden;
        int numChildren = this._childDeltas.size();
        if (numChildren == 0) {
            return this._childDeltas.toArray(new IResourceDelta[0]);
        }
        boolean includePhantoms = (memberFlags & 1) != 0;
        boolean includeTeamPrivate = (memberFlags & 2) != 0;
        boolean bl = includeHidden = (memberFlags & 8) != 0;
        if (includePhantoms) {
            kindMask |= 0x18;
        }
        int matching = 0;
        int i = 0;
        while (i < numChildren) {
            if (!((this._childDeltas.get(i).getKind() & kindMask) == 0 || !includePhantoms && this._childDeltas.get(i).isPhantom() || !includeTeamPrivate && this._childDeltas.get(i).isTeamPrivate() || !includeHidden && this._childDeltas.get(i).isHidden())) {
                ++matching;
            }
            ++i;
        }
        if (matching == numChildren) {
            ArrayList<MockResourceDelta> copy = new ArrayList<MockResourceDelta>(this._childDeltas);
            return copy.toArray(new IResourceDelta[0]);
        }
        IResourceDelta[] result = new IResourceDelta[matching];
        int nextPosition = 0;
        int i2 = 0;
        while (i2 < numChildren) {
            if (!((this._childDeltas.get(i2).getKind() & kindMask) == 0 || !includePhantoms && this._childDeltas.get(i2).isPhantom() || !includeTeamPrivate && this._childDeltas.get(i2).isTeamPrivate() || !includeHidden && this._childDeltas.get(i2).isHidden())) {
                result[nextPosition++] = this._childDeltas.get(i2);
            }
            ++i2;
        }
        return result;
    }

    public int getFlags() {
        return this._status & ~KIND_MASK;
    }

    private boolean isSet(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public IPath getFullPath() {
        return this.getActiveResource().getFullPath();
    }

    public int getKind() {
        return this._status & KIND_MASK;
    }

    public IMarkerDelta[] getMarkerDeltas() {
        throw new UnsupportedOperationException("getMarkerDeltas not supported by the mock");
    }

    public IPath getMovedFromPath() {
        if (this.isSet(4096)) {
            return this._beforeEventResource.getFullPath();
        }
        return null;
    }

    public IPath getMovedToPath() {
        if (this.isSet(8192)) {
            return this._afterEventResource.getFullPath();
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        return this._beforeEventResource.getProjectRelativePath();
    }

    public IResource getResource() {
        return this.getActiveResource();
    }

    public Object getAdapter(Class adapter) {
        return AdapterManager.getDefault().getAdapter((Object)this, adapter);
    }

    public IResource getActiveResource() {
        switch (this.getStateType()) {
            case AFTER_EVENT: {
                return this._afterEventResource;
            }
            case BEFORE_EVENT: {
                return this._beforeEventResource;
            }
        }
        throw new IllegalStateException("Should not get here");
    }

    public final List<MockResourceDelta> getChildDeltas() {
        return this._childDeltas;
    }

    private StateType getStateType() {
        if (this.getKind() == 1 || this.getKind() == 8 || this.isSet(4096)) {
            return StateType.AFTER_EVENT;
        }
        return StateType.BEFORE_EVENT;
    }

    protected boolean isHidden() {
        return false;
    }

    protected boolean isPhantom() {
        return false;
    }

    protected boolean isTeamPrivate() {
        return false;
    }

    public String toString() {
        return String.format("%s [delta]", this.getActiveResource().getFullPath());
    }

    public static enum StateType {
        BEFORE_EVENT,
        AFTER_EVENT;

    }
}

