/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import junit.framework.TestCase;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.ui.SelectionConverter;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.editor.DOMSelectionConverterFactory;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.eclipse.wst.xml.ui.tests.XMLUITestsPlugin;
import org.w3c.dom.NodeList;

public class TestOpenEditorXML
extends TestCase {
    private final String PROJECT_NAME = "TestOpenEditorXML";
    private final String FILE_NAME = "testStructuredTextEditorXML.xml";
    private static IEditorPart fEditor;
    private static IFile fFile;
    private static boolean fIsSetup;

    static {
        fIsSetup = false;
    }

    public TestOpenEditorXML() {
        super("TestStructuredTextEditorXML");
    }

    protected void setUp() throws Exception {
        if (!fIsSetup) {
            this.createProject("TestOpenEditorXML");
            fFile = this.getOrCreateFile("TestOpenEditorXML/testStructuredTextEditorXML.xml");
            fIsSetup = true;
        }
        TestOpenEditorXML.assertTrue((String)("Input file not accessible: " + fFile.getFullPath()), (boolean)fFile.isAccessible());
        if (fIsSetup && fEditor == null) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            fEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)fFile, (boolean)true, (boolean)true);
            TestOpenEditorXML.assertTrue((String)("Unable to open structured text editor " + fEditor), (fEditor instanceof XMLMultiPageEditorPart || fEditor instanceof StructuredTextEditor ? 1 : 0) != 0);
        }
    }

    protected void tearDown() throws Exception {
        if (fEditor != null) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            page.closeEditor(fEditor, false);
            TestOpenEditorXML.assertTrue((String)"Unable to close editor", (boolean)true);
            fEditor = null;
        }
    }

    private void createProject(String projName) throws CoreException {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        project.create(description, (IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
    }

    private IFile getOrCreateFile(String filePath) {
        IFile blankFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankFile != null && !blankFile.exists()) {
            try {
                blankFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankFile;
    }

    public void testSetDocument() {
        IDocument document = (IDocument)fEditor.getAdapter(IDocument.class);
        try {
            document.set("<hello></hello>");
        }
        catch (Exception e) {
            TestOpenEditorXML.assertTrue((String)("Unable to set text in editor: " + e), (boolean)false);
        }
    }

    public void testBug151069() {
        IDocument doc = (IDocument)fEditor.getAdapter(IDocument.class);
        doc.set("<html><body><h1>Title</h1></body></html>");
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IDOMModel model = null;
        try {
            model = (IDOMModel)modelManager.getExistingModelForEdit(doc);
            if (model != null) {
                NodeList nl = model.getDocument().getElementsByTagName("h1");
                IDOMElement h1 = (IDOMElement)nl.item(0);
                h1.setEditable(false, true);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
        String newContent = "new content";
        ((IDocumentExtension4)doc).set(newContent, fFile.getModificationStamp());
        TestOpenEditorXML.assertEquals((String)"Set contents in document with read only regions failed", (String)newContent, (String)doc.get());
    }

    public void testOpenOnLocalFileStore() throws Exception {
        IPath stateLocation = XMLUITestsPlugin.getDefault().getStateLocation();
        File file = stateLocation.append("testStructuredTextEditorXML.xml").toFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        InputStream contents = fFile.getContents();
        if (contents != null) {
            byte[] bytes = new byte[2048];
            try {
                int c;
                while ((c = contents.read(bytes)) >= 0) {
                    buffer.write(bytes, 0, c);
                }
                contents.close();
            }
            catch (IOException iOException) {}
        }
        fileOutputStream.write(buffer.toByteArray());
        URI uri = URIUtil.toURI((IPath)new Path(file.getAbsolutePath()));
        IFileStore store = EFS.getStore((URI)uri);
        FileStoreEditorInput input = new FileStoreEditorInput(store);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart");
        page.closeEditor(editor, false);
        TestOpenEditorXML.assertTrue((String)("Unable to open structured text editor " + fEditor), (fEditor instanceof XMLMultiPageEditorPart || fEditor instanceof StructuredTextEditor ? 1 : 0) != 0);
    }

    public void testSelectionConverter() {
        IDocument doc = (IDocument)fEditor.getAdapter(IDocument.class);
        doc.set("<html><body><h1>Title</h1></body></html>");
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IDOMModel model = null;
        try {
            model = (IDOMModel)modelManager.getExistingModelForEdit(doc);
            if (model != null) {
                String expected = DOMSelectionConverterFactory.XMLSelectionConverter.class.getName();
                String actual = ((SelectionConverter)model.getAdapter(SelectionConverter.class)).getClass().getName();
                TestOpenEditorXML.assertEquals((String)"The selection convertor for basic XML was not the expected type!", (String)expected, (String)actual);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }
}

