/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleType;
import org.eclipse.jst.jsf.facesconfig.emf.PhaseListenerType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteLifecycleTestCase
extends BaseWriteTestCase {
    protected static final String LIFECYCLE = "lifecycle";
    private static final String PHASELISTENER = "phase-listener";
    private static final String LIFECYCLE_ID = CommonStructuresUtil.createPreficedString("lifecycle", "id");

    public WriteLifecycleTestCase(String name) {
        super(name);
    }

    public void testWriteLifecycle() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteLifecycleTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            LifecycleType newLifecycle = facesConfigFactory.createLifecycleType();
            PhaseListenerType newPhaseListener = facesConfigFactory.createPhaseListenerType();
            newPhaseListener.setTextContent(PHASELISTENER);
            newPhaseListener.setId(CommonStructuresUtil.createPreficedString(PHASELISTENER, "id"));
            newLifecycle.getPhaseListener().add((Object)newPhaseListener);
            newLifecycle.setId(LIFECYCLE_ID);
            edit.getFacesConfig().getLifecycle().add((Object)newLifecycle);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteLifecycleTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteLifecycleTestCase.assertNotNull((Object)edit.getFacesConfig());
            LifecycleType newLifecycle = (LifecycleType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getLifecycle(), LIFECYCLE_ID);
            WriteLifecycleTestCase.assertNotNull((Object)newLifecycle);
            WriteLifecycleTestCase.assertEquals((int)1, (int)newLifecycle.getPhaseListener().size());
            PhaseListenerType newPhaseListener = (PhaseListenerType)newLifecycle.getPhaseListener().get(0);
            WriteLifecycleTestCase.assertEquals((String)PHASELISTENER, (String)newPhaseListener.getTextContent());
            WriteLifecycleTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(PHASELISTENER, "id"), (String)newPhaseListener.getId());
            WriteLifecycleTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(LIFECYCLE, "id"), (String)newLifecycle.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

