/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadReferencedBeanTestCase
extends BaseReadTestCase {
    public ReadReferencedBeanTestCase(String name) {
        super(name);
    }

    public void testSingleReferncedBean() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadReferencedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadReferencedBeanTestCase.assertNotNull((Object)this.getReferencedBean1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ReferencedBeanType getReferencedBean1(FacesConfigType facesConfig) {
        return (ReferencedBeanType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getReferencedBean(), "referencedBean1");
    }

    public void testDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadReferencedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReferencedBeanType referencedBean = this.getReferencedBean1(edit.getFacesConfig());
            ReadReferencedBeanTestCase.assertNotNull((Object)referencedBean);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)referencedBean.getDescription(), "referencedBean1Description");
            ReadReferencedBeanTestCase.assertNotNull((Object)descType);
            ReadReferencedBeanTestCase.assertEquals((String)"Referenced Bean Desc", (String)descType.getTextContent());
            DisplayNameType displayName = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)referencedBean.getDisplayName(), "referencedBean1DisplayName");
            ReadReferencedBeanTestCase.assertNotNull((Object)displayName);
            ReadReferencedBeanTestCase.assertEquals((String)"referenced-bean-display", (String)displayName.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)referencedBean.getIcon(), "referencedBean1Icon");
            ReadReferencedBeanTestCase.assertNotNull((Object)iconType);
            ReadReferencedBeanTestCase.assertEquals((String)"referenced-bean-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadReferencedBeanTestCase.assertEquals((String)"referenced-bean-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSingleValuedProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadReferencedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReferencedBeanType referencedBean = this.getReferencedBean1(edit.getFacesConfig());
            ReadReferencedBeanTestCase.assertNotNull((Object)referencedBean);
            ReadReferencedBeanTestCase.assertEquals((String)"referencedBeanName", (String)referencedBean.getReferencedBeanName().getTextContent().trim());
            ReadReferencedBeanTestCase.assertEquals((String)"referenced-bean-class", (String)referencedBean.getReferencedBeanClass().getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

