/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.command.InterruptibleCommand;
import org.eclipse.jpt.common.utility.internal.command.InterruptibleCommandAdapter;
import org.eclipse.jpt.common.utility.internal.reference.SimpleBooleanReference;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;
import org.eclipse.jpt.common.utility.reference.ModifiableBooleanReference;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class SynchronizedBooleanTests
extends MultiThreadedTestCase {
    private volatile SynchronizedBoolean sb;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;

    public SynchronizedBooleanTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sb = new SynchronizedBoolean();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
    }

    public void testGetValue() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testIs() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.is(false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.is(true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.is(true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.is(false));
    }

    public void testIsNot() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isNot(true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isNot(false));
    }

    public void testIsTrue() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
    }

    public void testIsFalse() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
    }

    public void testSetValueFalse() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(false));
    }

    public void testSetValueTrue() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setValue(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.setValue(true));
    }

    public void testFlip() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.flip());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.flip());
    }

    public void testFalseAndTrue() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.and(true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testTrueAndTrue() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.and(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testFalseAndFalse() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.and(false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testTrueAndFalse() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.and(false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testFalseOrTrue() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.or(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testTrueOrTrue() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.or(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testFalseOrFalse() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.or(false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testTrueOrFalse() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.or(false));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testFalseXorTrue() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.xor(true));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testTrueXorTrue() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.xor(true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testFalseXorFalse() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.xor(false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testTrueXorFalse() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.xor(false));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testSetNotTrue() throws Exception {
        this.sb.setNot(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
    }

    public void testSetNotFalse() throws Exception {
        this.sb.setNot(false);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
    }

    public void testSetFalse() throws Exception {
        this.sb.setFalse();
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
    }

    public void testSetTrue() throws Exception {
        this.sb.setTrue();
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
    }

    public void testCommitFalseSuccess() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.commit(false, false));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testCommitTrueSuccess() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.commit(true, false));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testCommitFalseFailure() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.commit(false, true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testCommitTrueFailure() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.commit(true, true));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testSwapSame1() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.swap((ModifiableBooleanReference)this.sb));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testSwapSameValues1() throws Exception {
        SimpleBooleanReference sb2 = new SimpleBooleanReference(false);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.swap((ModifiableBooleanReference)sb2));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
    }

    public void testSwapDifferentValues1() throws Exception {
        SimpleBooleanReference sb2 = new SimpleBooleanReference(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.swap((ModifiableBooleanReference)sb2));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
    }

    public void testSwapSame2() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.swap(this.sb));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testSwapSameValues2() throws Exception {
        SynchronizedBoolean sb2 = new SynchronizedBoolean();
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.swap(sb2));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.swap(this.sb));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
    }

    public void testSwapDifferentValues2() throws Exception {
        SynchronizedBoolean sb2 = new SynchronizedBoolean(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.swap(sb2));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)sb2.swap(this.sb));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)sb2.getValue());
    }

    public void testSwpSameValues3() throws Exception {
        SynchronizedBoolean sb2 = new SynchronizedBoolean();
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.swap((ModifiableBooleanReference)sb2));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
    }

    public void testSwapDifferentValues3() throws Exception {
        SynchronizedBoolean sb2 = new SynchronizedBoolean(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.swap((ModifiableBooleanReference)sb2));
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)sb2.getValue());
    }

    public void testGetMutexThis() throws Exception {
        SynchronizedBooleanTests.assertSame((Object)this.sb, (Object)this.sb.getMutex());
    }

    public void testGetMutexObject() throws Exception {
        Object mutex = new Object();
        SynchronizedBoolean syncBool = new SynchronizedBoolean(mutex);
        SynchronizedBooleanTests.assertSame((Object)mutex, (Object)syncBool.getMutex());
    }

    public void testWaitUntilTrue() throws Exception {
        this.verifyWaitUntilTrue(-1L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilTrue2() throws Exception {
        this.verifyWaitUntilTrue(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilTrueTimeout() throws Exception {
        this.verifyWaitUntilTrue(TICK);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitUntilTrueTimeout2() throws Exception {
        this.verifyWaitUntilTrue(THREE_TICKS);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() >= TWO_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilTrue(long t2Timeout) throws Exception {
        this.sb.setFalse();
        this.executeThreads(this.buildSetTrueCommand(), this.buildWaitUntilTrueCommand(t2Timeout));
    }

    private Command buildWaitUntilTrueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedBoolean syncBool) throws InterruptedException {
                SynchronizedBooleanTests.this.startTime = System.currentTimeMillis();
                SynchronizedBooleanTests.this.timeoutOccurred = this.timeoutOccurred(syncBool);
                SynchronizedBooleanTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedBoolean syncBool) throws InterruptedException {
                if (timeout < 0L) {
                    syncBool.waitUntilTrue();
                    return false;
                }
                return !syncBool.waitUntilTrue(timeout);
            }
        };
    }

    public void testWaitUntilFalse() throws Exception {
        this.verifyWaitUntilFalse(-1L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilFalse2() throws Exception {
        this.verifyWaitUntilFalse(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilFalseTimeout() throws Exception {
        this.verifyWaitUntilFalse(TICK);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitUntilFalseTimeout2() throws Exception {
        this.verifyWaitUntilFalse(THREE_TICKS);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() >= TWO_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilFalse(long t2Timeout) throws Exception {
        this.sb.setTrue();
        this.executeThreads(this.buildSetFalseCommand(), this.buildWaitUntilFalseCommand(t2Timeout));
    }

    private Command buildWaitUntilFalseCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedBoolean syncBool) throws InterruptedException {
                SynchronizedBooleanTests.this.startTime = System.currentTimeMillis();
                SynchronizedBooleanTests.this.timeoutOccurred = this.timeoutOccurred(syncBool);
                SynchronizedBooleanTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedBoolean syncBool) throws InterruptedException {
                if (timeout < 0L) {
                    syncBool.waitUntilFalse();
                    return false;
                }
                return !syncBool.waitUntilFalse(timeout);
            }
        };
    }

    public void testWaitUntilValueIsNotTrue() throws Exception {
        this.sb.waitUntilValueIsNot(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testWaitUntilValueIsNotFalse() throws Exception {
        this.sb.setTrue();
        this.sb.waitUntilValueIsNot(false);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testWaitUntilValueIsNotTrueTimeout() throws Exception {
        this.sb.waitUntilValueIsNot(true, 500L);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testWaitUntilValueIsNotFalseTimeout() throws Exception {
        this.sb.setTrue();
        this.sb.waitUntilValueIsNot(false, 500L);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testWaitToSetTrue() throws Exception {
        this.verifyWaitToSetTrue(-1L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetTrue2() throws Exception {
        this.verifyWaitToSetTrue(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetTrueTimeout() throws Exception {
        this.verifyWaitToSetTrue(TICK);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitToSetTrueTimeout2() throws Exception {
        this.verifyWaitUntilTrue(THREE_TICKS);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() >= TWO_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToSetTrue(long t2Timeout) throws Exception {
        this.sb.setTrue();
        this.executeThreads(this.buildSetFalseCommand(), this.buildWaitToSetTrueCommand(t2Timeout));
    }

    private Command buildWaitToSetTrueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedBoolean syncBool) throws InterruptedException {
                SynchronizedBooleanTests.this.startTime = System.currentTimeMillis();
                SynchronizedBooleanTests.this.timeoutOccurred = this.timeoutOccurred(syncBool);
                SynchronizedBooleanTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedBoolean syncBool) throws InterruptedException {
                if (timeout < 0L) {
                    syncBool.waitToSetTrue();
                    return false;
                }
                return !syncBool.waitToSetTrue(timeout);
            }
        };
    }

    public void testWaitToSetFalse() throws Exception {
        this.verifyWaitToSetFalse(-1L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetFalse2() throws Exception {
        this.verifyWaitToSetFalse(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetFalseTimeout() throws Exception {
        this.verifyWaitToSetFalse(TICK);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitToSetFalseTimeout2() throws Exception {
        this.verifyWaitUntilFalse(THREE_TICKS);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() >= TWO_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToSetFalse(long t2Timeout) throws Exception {
        this.sb.setFalse();
        this.executeThreads(this.buildSetTrueCommand(), this.buildWaitToSetFalseCommand(t2Timeout));
    }

    private Command buildWaitToSetFalseCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedBoolean syncBool) throws InterruptedException {
                SynchronizedBooleanTests.this.startTime = System.currentTimeMillis();
                SynchronizedBooleanTests.this.timeoutOccurred = this.timeoutOccurred(syncBool);
                SynchronizedBooleanTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedBoolean syncBool) throws InterruptedException {
                if (timeout < 0L) {
                    syncBool.waitToSetFalse();
                    return false;
                }
                return !syncBool.waitToSetFalse(timeout);
            }
        };
    }

    public void testWaitToSetValueNotTrue() throws Exception {
        this.sb.waitToSetValueNot(false);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testWaitToSetValueNotFalse() throws Exception {
        this.sb.setTrue();
        this.sb.waitToSetValueNot(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testWaitToSetValueNotTrueTimeout() throws Exception {
        this.sb.waitToSetValueNot(false, 500L);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
    }

    public void testWaitToSetValueNotFalseTimeout() throws Exception {
        this.sb.setTrue();
        this.sb.waitToSetValueNot(true, 500L);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testExecute() throws Exception {
        SimpleBooleanReference done = new SimpleBooleanReference(false);
        this.sb.execute((InterruptibleCommand)new InterruptibleCommandAdapter((ModifiableBooleanReference)done){
            private final /* synthetic */ ModifiableBooleanReference val$done;
            {
                this.val$done = modifiableBooleanReference;
            }

            public void execute() throws InterruptedException {
                this.val$done.setTrue();
            }
        });
        SynchronizedBooleanTests.assertTrue((boolean)done.getValue());
    }

    public void testSerialization() throws Exception {
        this.sb.setTrue();
        SynchronizedBoolean clone = TestTools.serialize(this.sb);
        SynchronizedBooleanTests.assertNotSame((Object)this.sb, (Object)clone);
        SynchronizedBooleanTests.assertTrue((boolean)clone.getValue());
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        Runnable r1 = this.buildRunnable(t1Command, this.sb, TWO_TICKS);
        Runnable r2 = this.buildRunnable(t2Command, this.sb, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildSetTrueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedBoolean syncBool) {
                syncBool.setTrue();
            }
        };
    }

    private Command buildSetFalseCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedBoolean syncBool) {
                syncBool.setFalse();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedBoolean syncBool, final long delay) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            public void run_() throws InterruptedException {
                if (delay != 0L) {
                    Thread.sleep(delay);
                }
                command.execute(syncBool);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void testEquals() {
        SynchronizedBoolean sb2 = new SynchronizedBoolean(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.equals((Object)this.sb));
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.equals((Object)sb2));
    }

    public void testHashCode() {
        SynchronizedBooleanTests.assertEquals((int)this.sb.hashCode(), (int)this.sb.hashCode());
    }

    public void testClone() {
        SynchronizedBoolean clone = this.sb.clone();
        SynchronizedBooleanTests.assertFalse((boolean)clone.getValue());
        SynchronizedBooleanTests.assertNotSame((Object)clone, (Object)this.sb);
    }

    public void testToString() {
        SynchronizedBooleanTests.assertEquals((String)"[false]", (String)this.sb.toString());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.setTrue());
        SynchronizedBooleanTests.assertEquals((String)"[true]", (String)this.sb.toString());
    }

    private static interface Command {
        public void execute(SynchronizedBoolean var1) throws InterruptedException;
    }
}

