/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.factory.FactoryAdapter;
import org.eclipse.jpt.common.utility.internal.reference.LazyObjectReference;
import org.eclipse.jpt.common.utility.reference.ObjectReference;
import org.eclipse.jpt.common.utility.tests.internal.reference.ObjectReferenceTests;

public class LazyObjectReferenceTests
extends ObjectReferenceTests {
    public LazyObjectReferenceTests(String name) {
        super(name);
    }

    @Override
    protected ObjectReference<String> buildObjectReference(String value) {
        return new LazyObjectReference(this.buildFactory(value));
    }

    private Factory<String> buildFactory(String value) {
        return new LocalFactory(value);
    }

    @Override
    public void testGetValue() {
        super.testGetValue();
        ObjectReference<String> ref = this.buildObjectReference();
        LazyObjectReferenceTests.assertNull((Object)ref.getValue());
        ref = this.buildObjectReference("foo");
        LazyObjectReferenceTests.assertEquals((String)"foo", (String)((String)ref.getValue()));
        LazyObjectReferenceTests.assertEquals((String)"foo", (String)((String)ref.getValue()));
    }

    public void testClone() {
        ObjectReference<String> or = this.buildObjectReference("foo");
        ObjectReference clone = (ObjectReference)ObjectTools.execute(or, (String)"clone");
        LazyObjectReferenceTests.assertEquals((String)"foo", (String)((String)clone.getValue()));
        LazyObjectReferenceTests.assertNotSame(or, (Object)clone);
    }

    private static class LocalFactory
    extends FactoryAdapter<String> {
        protected String value;

        protected LocalFactory(String value) {
            this.value = value;
        }

        public String create() {
            return this.value;
        }
    }
}

