/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public abstract class DequeTests
extends MultiThreadedTestCase {
    public DequeTests(String name) {
        super(name);
    }

    abstract Deque<String> buildDeque();

    public void testIsEmpty() {
        Deque<String> queue = this.buildDeque();
        DequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        DequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        DequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"zero");
        DequeTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeueHead();
        DequeTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeueHead();
        DequeTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeueTail();
        DequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueTailAndDequeueHead() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
    }

    public void testEnqueueHeadAndDequeueTail() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueHead((Object)first);
        queue.enqueueHead((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
    }

    public void testEnqueueAndDequeue() {
        Deque<String> queue = this.buildDeque();
        String negative = "negative";
        String zero = "zero";
        String first = "first";
        String second = "second";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        queue.enqueueHead((Object)zero);
        queue.enqueueHead((Object)negative);
        DequeTests.assertEquals((String)negative, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        DequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueTailAndPeekHead() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
    }

    public void testEnqueueHeadAndPeekTail() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueHead((Object)first);
        queue.enqueueHead((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
    }

    public void testEnqueueAndPeek() {
        Deque<String> queue = this.buildDeque();
        String negative = "negative";
        String zero = "zero";
        String first = "first";
        String second = "second";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        queue.enqueueHead((Object)zero);
        queue.enqueueHead((Object)negative);
        DequeTests.assertEquals((String)negative, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)negative, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)negative, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)zero, (String)((String)queue.dequeueTail()));
        DequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEmptyDequeExceptionPeekHead() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
        boolean exCaught = false;
        try {
            queue.peekHead();
            DequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        DequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyDequeExceptionPeekTail() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueHead((Object)first);
        queue.enqueueHead((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
        boolean exCaught = false;
        try {
            queue.peekTail();
            DequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        DequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyDequeExceptionDequeueHead() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueTail((Object)first);
        queue.enqueueTail((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
        boolean exCaught = false;
        try {
            queue.dequeueHead();
            DequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        DequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyDequeExceptionDequeueTail() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        queue.enqueueHead((Object)first);
        queue.enqueueHead((Object)second);
        DequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        DequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
        boolean exCaught = false;
        try {
            queue.dequeueTail();
            DequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        DequeTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        Deque<String> queue = this.buildDeque();
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        Deque clone = (Deque)ObjectTools.execute(queue, (String)"clone");
        this.verifyClone(queue, (Deque<String>)clone);
    }

    public void testSerialization() throws Exception {
        Deque<String> queue = this.buildDeque();
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        this.verifyClone(queue, TestTools.serialize(queue));
    }

    protected void verifyClone(Deque<String> original, Deque<String> clone) {
        DequeTests.assertNotSame(original, clone);
        DequeTests.assertEquals((String)((String)original.peekHead()), (String)((String)clone.peekHead()));
        DequeTests.assertEquals((String)((String)original.dequeueHead()), (String)((String)clone.dequeueHead()));
        DequeTests.assertEquals((String)((String)original.peekHead()), (String)((String)clone.peekHead()));
        DequeTests.assertEquals((String)((String)original.dequeueHead()), (String)((String)clone.dequeueHead()));
        DequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        DequeTests.assertEquals((String)((String)original.peekTail()), (String)((String)clone.peekTail()));
        DequeTests.assertEquals((String)((String)original.dequeueTail()), (String)((String)clone.dequeueTail()));
        DequeTests.assertTrue((boolean)original.isEmpty());
        DequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueueTail((Object)"fourth");
        DequeTests.assertFalse((boolean)original.isEmpty());
        DequeTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testToString() throws Exception {
        Deque<String> queue = this.buildDeque();
        DequeTests.assertEquals((String)"[]", (String)queue.toString());
        queue.enqueueTail((Object)"first");
        DequeTests.assertEquals((String)"[first]", (String)queue.toString());
        queue.enqueueTail((Object)"second");
        DequeTests.assertEquals((String)"[first, second]", (String)queue.toString());
        queue.enqueueTail((Object)"third");
        DequeTests.assertEquals((String)"[first, second, third]", (String)queue.toString());
        queue.enqueueHead((Object)"foo");
        DequeTests.assertEquals((String)"[foo, first, second, third]", (String)queue.toString());
    }
}

