/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMIntegerTypeBeanProxy
extends REMConstantBeanProxy
implements IIntegerBeanProxy {
    private final int fInt;

    REMIntegerTypeBeanProxy(REMProxyFactoryRegistry aRegistry, int anInt) {
        super(aRegistry);
        this.fInt = anInt;
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof REMIntegerTypeBeanProxy) {
            return this.fInt == ((REMIntegerTypeBeanProxy)anObject).intValue();
        }
        if (anObject instanceof Integer) {
            return this.fInt == (Integer)anObject;
        }
        return false;
    }

    @Override
    public boolean sameAs(IBeanProxy aBeanProxy) {
        if (this == aBeanProxy) {
            return true;
        }
        if (aBeanProxy instanceof REMIntegerTypeBeanProxy) {
            return this.fInt == ((REMIntegerTypeBeanProxy)aBeanProxy).intValue();
        }
        return false;
    }

    @Override
    public byte byteValue() {
        return (byte)this.fInt;
    }

    @Override
    public double doubleValue() {
        return this.fInt;
    }

    @Override
    public float floatValue() {
        return this.fInt;
    }

    @Override
    public int intValue() {
        return this.fInt;
    }

    @Override
    public long longValue() {
        return this.fInt;
    }

    @Override
    public Number numberValue() {
        return new Integer(this.fInt);
    }

    @Override
    public short shortValue() {
        return (short)this.fInt;
    }

    @Override
    public String toBeanString() {
        return String.valueOf(this.fInt);
    }

    @Override
    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory()).intType;
    }

    @Override
    public void renderBean(Commands.ValueObject value) {
        value.set(this.fInt);
    }
}

