/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.ClassloaderWSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ValidationController;
import org.eclipse.wst.wsdl.validation.internal.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ClassloaderWSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11BasicValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorController;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.http.HTTPValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.mime.MIMEValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.soap.SOAPValidator;

public class WSDLValidator {
    private static String VALIDATOR_RESOURCE_BUNDLE = "validatewsdl";
    private ValidationController validationController;
    protected URIResolver uriResolver;

    public WSDLValidator() {
        ResourceBundle rb = ResourceBundle.getBundle(VALIDATOR_RESOURCE_BUNDLE);
        this.uriResolver = new URIResolver();
        this.validationController = new ValidationController(rb, this.uriResolver);
        ValidatorRegistry registry = ValidatorRegistry.getInstance();
        ClassloaderWSDLValidatorDelegate delegate = new ClassloaderWSDLValidatorDelegate(WSDL11ValidatorController.class.getName(), this.getClass().getClassLoader());
        registry.registerValidator("http://schemas.xmlsoap.org/wsdl/", delegate, ValidatorRegistry.WSDL_VALIDATOR);
        ClassloaderWSDL11ValidatorDelegate delegate1 = new ClassloaderWSDL11ValidatorDelegate(WSDL11BasicValidator.class.getName(), this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/", delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(HTTPValidator.class.getName(), this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/http/", delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(SOAPValidator.class.getName(), this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/soap/", delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(MIMEValidator.class.getName(), this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/mime/", delegate1);
    }

    public IValidationReport validate(String uri) {
        return this.validate(uri, null, new WSDLValidationConfiguration());
    }

    public IValidationReport validate(String uri, InputStream inputStream, WSDLValidationConfiguration configuration) {
        if (uri == null) {
            return null;
        }
        if (configuration == null) {
            configuration = new WSDLValidationConfiguration();
        }
        return this.validationController.validate(uri, inputStream, configuration);
    }

    public void addURIResolver(IExtensibleURIResolver uriResolver) {
        this.uriResolver.addURIResolver(uriResolver);
    }

    public void registerWSDLExtensionValidator(String namespace, WSDLValidatorDelegate delegate) {
        ValidatorRegistry.getInstance().registerValidator(namespace, delegate, ValidatorRegistry.EXT_VALIDATOR);
    }

    public void registerWSDL11Validator(String namespace, WSDL11ValidatorDelegate delegate) {
        org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry.getInstance().registerValidator(namespace, delegate);
    }
}

