/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.json.IValidationReporter;
import org.eclipse.json.impl.schema.JSONSchemaDocument;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.provisonnal.com.eclipsesource.json.ParseException;

public class ValidatorHelper {
    public static void validate(Reader json, IValidationReporter reporter) {
        ValidatorHelper.getJson(json, reporter);
    }

    public static void validate(Reader json, JSONSchemaDocument schema, IValidationReporter reporter) {
        JsonValue value = ValidatorHelper.getJson(json, reporter);
        if (value != null) {
            schema.validate(value, reporter);
        }
    }

    private static JsonValue getJson(Reader json, IValidationReporter reporter) {
        try {
            return JsonValue.readFrom(json);
        }
        catch (IOException e) {
            reporter.addMessage(e.getMessage(), 0, 0, 0);
            return null;
        }
        catch (ParseException e) {
            reporter.addMessage(e.getMessage(), e.getLine(), e.getColumn(), e.getOffset());
            return null;
        }
    }
}

