/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.Modifier;
import java.util.Collection;
import javax.jws.WebService;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebServiceDefaultPublicConstructorRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof ClassDeclaration) || declaration instanceof EnumDeclaration) continue;
            boolean hasDefaultConstructor = false;
            ClassDeclaration classDeclaration = (ClassDeclaration)declaration;
            Collection constructors = classDeclaration.getConstructors();
            if (constructors.size() == 0) {
                hasDefaultConstructor = true;
            } else {
                for (ConstructorDeclaration constructorDeclaration : constructors) {
                    if (!constructorDeclaration.getModifiers().contains(Modifier.PUBLIC) || constructorDeclaration.getParameters().size() != 0) continue;
                    hasDefaultConstructor = true;
                    break;
                }
            }
            if (hasDefaultConstructor) continue;
            Collection annotationMirrors = declaration.getAnnotationMirrors();
            for (AnnotationMirror mirror : annotationMirrors) {
                if (!mirror.getAnnotationType().toString().equals(annotationDeclaration.getQualifiedName())) continue;
                this.printFixableError(declaration.getPosition(), JAXWSCoreMessages.WEBSERVICE_DEFAULT_PUBLIC_CONSTRUCTOR);
            }
        }
    }
}

