/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.jmx;

import java.util.List;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;

public class Handler {

    @ManagedObject
    public static class AbstractMBean
    extends ObjectMBean {
        public AbstractMBean(Object managedObject) {
            super(managedObject);
        }

        public Handler.Abstract getManagedObject() {
            return (Handler.Abstract)super.getManagedObject();
        }

        public String getObjectContextBasis() {
            ContextHandler context;
            Object object = this._managed;
            if (object instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)object;
                String contextName = this.getContextName(contextHandler);
                if (contextName == null) {
                    contextName = contextHandler.getDisplayName();
                }
                return contextName;
            }
            String basis = null;
            Handler.Abstract handler = this.getManagedObject();
            Server server = handler.getServer();
            if (server != null && (context = (ContextHandler)server.getContainer(handler, ContextHandler.class)) != null) {
                basis = this.getContextName(context);
            }
            return basis;
        }

        protected String getContextName(ContextHandler context) {
            List<String> vhosts;
            String name = null;
            String contextPath = context.getContextPath();
            if (contextPath != null && !contextPath.isEmpty()) {
                int idx = contextPath.lastIndexOf(47);
                String string = name = idx < 0 ? contextPath : contextPath.substring(++idx);
                if (name.isEmpty()) {
                    name = "ROOT";
                }
            }
            if (name == null && context.getBaseResource() != null) {
                name = context.getBaseResource().getPath().getFileName().toString();
            }
            if (!(vhosts = context.getVirtualHosts()).isEmpty()) {
                name = "\"%s@%s\"".formatted(name, vhosts.get(0));
            }
            return name;
        }
    }
}

