/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Iterator;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.preference.RectangleList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

final class TitleBarButton
extends Button {
    private boolean state = false;
    private Image uncheckedImage;
    private Image checkedImage;
    private Image uncheckedHiliteImage;
    private Image checkedHiliteImage;
    private RectangleList uncheckedRects;
    private RectangleList checkedRects;
    private boolean hilite = false;

    public TitleBarButton(Image unchecked, Image uncheckedHilite, Image checked, Image checkedHilite) {
        this.uncheckedImage = unchecked;
        this.uncheckedHiliteImage = uncheckedHilite == null ? unchecked : uncheckedHilite;
        this.checkedImage = checked == null ? unchecked : checked;
        this.checkedHiliteImage = checkedHilite == null ? unchecked : checkedHilite;
        this.initialize();
    }

    public TitleBarButton(RectangleList rects) {
        this.uncheckedRects = rects;
        this.initialize();
    }

    public TitleBarButton(RectangleList unchecked, RectangleList checked) {
        this.uncheckedRects = unchecked;
        this.checkedRects = checked;
        this.initialize();
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean newState) {
        this.state = newState;
        this.hilite = false;
    }

    private void initialize() {
        this.setRequestFocusEnabled(true);
        this.setFocusTraversable(true);
        if (this.uncheckedImage != null) {
            Rectangle r = this.uncheckedImage.getBounds();
            this.setBounds(new org.eclipse.draw2d.geometry.Rectangle(0, 0, r.width, r.height));
            this.prefSize = new Dimension(r.width, r.height);
        } else {
            this.setForegroundColor(ColorConstants.black);
            this.setBackgroundColor(ColorConstants.white);
            this.calculatePreferredSize();
            this.setBounds(new org.eclipse.draw2d.geometry.Rectangle(0, 0, this.prefSize.width, this.prefSize.height));
        }
        this.setCursor(Cursors.ARROW);
        this.setBorder(null);
        this.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TitleBarButton.this.setState(!TitleBarButton.this.state);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                TitleBarButton.this.hilite = true;
                TitleBarButton.this.repaint();
            }

            public void mouseExited(MouseEvent me) {
                TitleBarButton.this.hilite = false;
                TitleBarButton.this.repaint();
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    public Dimension calculatePreferredSize() {
        if (this.prefSize == null) {
            org.eclipse.draw2d.geometry.Rectangle r;
            Iterator iter;
            org.eclipse.draw2d.geometry.Rectangle rect = new org.eclipse.draw2d.geometry.Rectangle(0, 0, 0, 0);
            if (this.uncheckedRects != null) {
                iter = this.uncheckedRects.iterator();
                while (iter.hasNext()) {
                    this.getLocation();
                    r = ((org.eclipse.draw2d.geometry.Rectangle)iter.next()).getCopy();
                    rect = rect.getUnion(r);
                }
            }
            if (this.checkedRects != null) {
                iter = this.checkedRects.iterator();
                while (iter.hasNext()) {
                    this.getLocation();
                    r = ((org.eclipse.draw2d.geometry.Rectangle)iter.next()).getCopy();
                    rect = rect.getUnion(r);
                }
            }
            this.prefSize = rect.getSize();
            if (this.prefSize.width > this.prefSize.height) {
                this.prefSize.height = this.prefSize.width;
            } else if (this.prefSize.height > this.prefSize.width) {
                this.prefSize.width = this.prefSize.height;
            }
            this.prefSize.width += 4;
            this.prefSize.height += 4;
        }
        return this.prefSize;
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        if (this.uncheckedImage != null) {
            if (this.hilite) {
                if (!this.state) {
                    graphics.drawImage(this.uncheckedHiliteImage, this.getLocation());
                } else {
                    graphics.drawImage(this.checkedHiliteImage, this.getLocation());
                }
            } else if (!this.state) {
                graphics.drawImage(this.uncheckedImage, this.getLocation());
            } else {
                graphics.drawImage(this.checkedImage, this.getLocation());
            }
        } else {
            Iterator iter = null;
            iter = !this.state ? this.uncheckedRects.iterator() : this.checkedRects.iterator();
            while (iter.hasNext()) {
                Point p = this.getLocation();
                org.eclipse.draw2d.geometry.Rectangle r = ((org.eclipse.draw2d.geometry.Rectangle)iter.next()).getCopy();
                r = r.translate(p.x, p.y);
                graphics.setForegroundColor(this.getForegroundColor());
                if (this.hilite) {
                    graphics.setBackgroundColor(ColorConstants.lightBlue);
                } else {
                    graphics.setBackgroundColor(ColorConstants.white);
                }
                graphics.fillRectangle(r);
                graphics.drawRectangle(r);
            }
        }
    }
}

