/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.listeners;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.queue.SynchronizedQueue;
import org.eclipse.swt.widgets.Display;

final class SWTListenerWrapperDelegate<E extends EventObject> {
    private final Wrapper<E> wrapper;
    private final Display display;
    private final Runnable forwardEventsRunnable = new ForwardEventsRunnable();
    private final ExceptionHandler exceptionHandler;
    private final SynchronizedQueue<E> events = QueueTools.synchronizedQueue();

    SWTListenerWrapperDelegate(Wrapper<E> wrapper, Display display, ExceptionHandler exceptionHandler) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.wrapper = wrapper;
        if (display == null) {
            throw new NullPointerException();
        }
        this.display = display;
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    public void handle(E event) {
        this.events.enqueue(event);
        this.execute(this.forwardEventsRunnable);
    }

    private void execute(Runnable runnable) {
        DisplayTools.execute(this.display, runnable);
    }

    void forwardEvents() {
        ArrayList temp = this.events.drain();
        for (EventObject event : temp) {
            try {
                this.wrapper.forward(event);
            }
            catch (RuntimeException ex) {
                this.exceptionHandler.handleException((Throwable)ex);
            }
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.wrapper);
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        public void run() {
            SWTListenerWrapperDelegate.this.forwardEvents();
        }
    }

    public static interface Wrapper<E extends EventObject> {
        public void forward(E var1);
    }
}

