/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SpinnerModelAdapter {
    protected final ModifiablePropertyValueModel<Integer> numberHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected final Spinner spinner;
    protected final ModifyListener spinnerModifyListener;
    protected final DisposeListener spinnerDisposeListener;
    protected final int defaultValue;
    private boolean locked;

    public static SpinnerModelAdapter adapt(ModifiablePropertyValueModel<Integer> numberHolder, Spinner spinner, int defaultValue) {
        return new SpinnerModelAdapter(numberHolder, spinner, defaultValue);
    }

    protected SpinnerModelAdapter(ModifiablePropertyValueModel<Integer> numberHolder, Spinner spinner, int defaultValue) {
        if (numberHolder == null || spinner == null) {
            throw new NullPointerException();
        }
        this.numberHolder = numberHolder;
        this.spinner = spinner;
        this.defaultValue = defaultValue;
        this.propertyChangeListener = this.buildPropertyChangeListener();
        this.numberHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.spinnerModifyListener = this.buildSpinnerModifyListener();
        this.spinner.addModifyListener(this.spinnerModifyListener);
        this.spinnerDisposeListener = this.buildSpinnerDisposeListener();
        this.spinner.addDisposeListener(this.spinnerDisposeListener);
        this.updateSpinner((Integer)numberHolder.getValue());
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return SWTListenerTools.wrap(this.buildPropertyChangeListener_(), (Widget)this.spinner);
    }

    protected PropertyChangeListener buildPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                SpinnerModelAdapter.this.valueChanged(event);
            }

            public String toString() {
                return "spinner listener";
            }
        };
    }

    protected ModifyListener buildSpinnerModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpinnerModelAdapter.this.spinnerModified(e);
            }

            public String toString() {
                return "spinner selection listener";
            }
        };
    }

    protected DisposeListener buildSpinnerDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SpinnerModelAdapter.this.spinnerDisposed(event);
            }

            public String toString() {
                return "spinner dispose listener";
            }
        };
    }

    protected void valueChanged(PropertyChangeEvent event) {
        if (!this.locked) {
            this.updateSpinner((Integer)event.getNewValue());
        }
    }

    protected void spinnerModified(ModifyEvent event) {
        if (!this.locked) {
            this.locked = true;
            try {
                this.numberHolder.setValue((Object)this.spinner.getSelection());
            }
            finally {
                this.locked = false;
            }
        }
    }

    protected void spinnerDisposed(DisposeEvent event) {
        this.spinner.removeDisposeListener(this.spinnerDisposeListener);
        this.spinner.removeModifyListener(this.spinnerModifyListener);
        this.numberHolder.removePropertyChangeListener("value", this.propertyChangeListener);
    }

    protected void updateSpinner(Integer value) {
        if (this.spinner.isDisposed()) {
            return;
        }
        if (value == null) {
            value = this.defaultValue;
        }
        this.locked = true;
        try {
            this.spinner.setSelection(value.intValue());
        }
        finally {
            this.locked = false;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.numberHolder);
    }
}

