/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.eclipse.wst.ws.internal.datamodel.BasicModel;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.favorites.FavoritesRegistryTypeDefault;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.AddRegistryToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIRegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIRegistryFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Perspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.OpenRegistryAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindServiceUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.SwitchPerspectiveFromUDDIAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.UDDIMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RootCategoryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIMainNode;
import org.eclipse.wst.ws.internal.explorer.platform.util.DirUtils;
import org.eclipse.wst.ws.internal.explorer.platform.util.URLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesUDDIRegistry;

public class UDDIPerspective
extends Perspective {
    private Hashtable knownRegistries_;
    private IFavoritesUDDIRegistry defaultUDDIRegistry_;
    private Model navigatorModel_;
    private NodeManager navigatorManager_;
    private int wsdlType_;
    private Hashtable categoryManagers_;
    String categoryTModelKey_;
    private String perspectiveContentFramesetCols_;
    private String savedPerspectiveContentFramesetCols_;
    private String actionsContainerFramesetRows_;
    private String savedActionsContainerFramesetRows_;

    public UDDIPerspective(Controller controller) {
        super("uddi", controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initPerspective(ServletContext application) {
        String defaultFavorites = this.controller_.getDefaultFavoritesLocation();
        FavoritesRegistryTypeDefault favRegTypeDefault = new FavoritesRegistryTypeDefault(defaultFavorites);
        IFavoritesUDDIRegistry[] favRegistriesDefault = favRegTypeDefault.getFavoritesUDDIRegistries();
        this.knownRegistries_ = new Hashtable();
        int i = 0;
        while (i < favRegistriesDefault.length) {
            this.knownRegistries_.put(favRegistriesDefault[i].getInquiryURL(), favRegistriesDefault[i]);
            ++i;
        }
        if (favRegistriesDefault.length > 0) {
            this.defaultUDDIRegistry_ = favRegistriesDefault[0];
        }
        this.navigatorModel_ = new BasicModel("uddiModel");
        UDDIMainElement uddiMainElement = new UDDIMainElement(this.getMessage("NODE_NAME_UDDI_MAIN"), this.navigatorModel_);
        this.navigatorModel_.setRootElement((Element)uddiMainElement);
        this.navigatorManager_ = new NodeManager(this.controller_);
        UDDIMainNode uddiMainNode = new UDDIMainNode(uddiMainElement, this.navigatorManager_);
        this.navigatorManager_.setRootNode(uddiMainNode);
        this.wsdlType_ = 0;
        this.categoryManagers_ = new Hashtable();
        if (application.getAttribute("commonCategoryModels") == null) {
            ServletContext servletContext = application;
            synchronized (servletContext) {
                if (application.getAttribute("commonCategoryModels") == null) {
                    Hashtable<String, CategoryModel> commonCategoryModels = new Hashtable<String, CategoryModel>();
                    CategoryModel naicsModel = new CategoryModel();
                    naicsModel.setServletContext(application);
                    naicsModel.setDefaultDataFile("/uddi/data/naics-data.txt");
                    naicsModel.setDisplayName(this.getMessage("FORM_OPTION_CATEGORY_NAICS"));
                    naicsModel.setTModelKey("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2");
                    commonCategoryModels.put("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2", naicsModel);
                    CategoryModel unspscModel = new CategoryModel();
                    unspscModel.setServletContext(application);
                    unspscModel.setDefaultDataFile("/uddi/data/unspsc-data.txt");
                    unspscModel.setDisplayName(this.getMessage("FORM_OPTION_CATEGORY_UNSPSC_73"));
                    unspscModel.setTModelKey("UUID:CD153257-086A-4237-B336-6BDCBDCC6634");
                    commonCategoryModels.put("UUID:CD153257-086A-4237-B336-6BDCBDCC6634", unspscModel);
                    CategoryModel geoModel = new CategoryModel();
                    geoModel.setServletContext(application);
                    geoModel.setDefaultDataFile("/uddi/data/geo-data.txt");
                    geoModel.setDisplayName(this.getMessage("FORM_OPTION_CATEGORY_GEO"));
                    geoModel.setTModelKey("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88");
                    commonCategoryModels.put("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88", geoModel);
                    application.setAttribute("commonCategoryModels", commonCategoryModels);
                }
            }
        }
        this.categoryTModelKey_ = null;
        this.perspectiveContentFramesetCols_ = !DirUtils.isRTL() ? "30%,*" : "*,30%";
        this.savedPerspectiveContentFramesetCols_ = this.perspectiveContentFramesetCols_;
        this.savedActionsContainerFramesetRows_ = this.actionsContainerFramesetRows_ = "75%,*";
    }

    public final Hashtable getKnownRegistries() {
        FavoritesMainElement favMainElement = (FavoritesMainElement)this.controller_.getFavoritesPerspective().getNodeManager().getRootNode().getTreeElement();
        FavoritesUDDIRegistryFolderElement favRegFolderElement = favMainElement.getFavoritesUDDIRegistryFolderElement();
        Enumeration e = favRegFolderElement.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIRegistryElement favRegElement = (FavoritesUDDIRegistryElement)((Object)e.nextElement());
            String inquiryURL = favRegElement.getInquiryURL();
            if (this.knownRegistries_.get(inquiryURL) != null) continue;
            this.knownRegistries_.put(inquiryURL, favRegElement.getIFavoritesUDDIRegistryInterface());
        }
        return this.knownRegistries_;
    }

    public final String getKnownRegistryPublishURL(String inquiryURL) {
        String publishURL;
        IFavoritesUDDIRegistry knownRegistry = (IFavoritesUDDIRegistry)this.getKnownRegistries().get(inquiryURL);
        if (knownRegistry != null && Validator.validateURL(publishURL = knownRegistry.getPublishURL())) {
            return publishURL;
        }
        return null;
    }

    public final String getKnownRegistryRegistrationURL(String inquiryURL) {
        String registrationURL;
        IFavoritesUDDIRegistry knownRegistry = (IFavoritesUDDIRegistry)this.getKnownRegistries().get(inquiryURL);
        if (knownRegistry != null && Validator.validateURL(registrationURL = knownRegistry.getRegistrationURL())) {
            return registrationURL;
        }
        return null;
    }

    public final IFavoritesUDDIRegistry getDefaultUDDIRegistry() {
        return this.defaultUDDIRegistry_;
    }

    public final void preloadUDDIRegistries(String[] inquiryURLs, String[] publishURLs) {
        if (inquiryURLs != null) {
            Hashtable knownRegistries = this.getKnownRegistries();
            StringBuffer directoryBuffer = new StringBuffer();
            int i = 0;
            while (i < inquiryURLs.length) {
                String inquiryURL = URLUtils.decode(inquiryURLs[i]);
                String publishURL = null;
                String regName = null;
                String registrationURL = null;
                if (Validator.validateURL(inquiryURL)) {
                    OpenRegistryAction action = new OpenRegistryAction(this.controller_);
                    Hashtable propertyTable = action.getPropertyTable();
                    IFavoritesUDDIRegistry knownRegistry = (IFavoritesUDDIRegistry)knownRegistries.get(inquiryURL);
                    boolean checkForUserDefinedCategories = false;
                    File directoryFile = null;
                    if (knownRegistry != null) {
                        publishURL = knownRegistry.getPublishURL();
                        regName = knownRegistry.getName();
                        registrationURL = knownRegistry.getRegistrationURL();
                        directoryBuffer.setLength(0);
                        FavoritesUDDIRegistryFolderElement.formCategoriesDirectory(directoryBuffer, this.controller_.getServletEngineStateLocation(), regName);
                        directoryFile = new File(directoryBuffer.toString());
                        if (directoryFile.exists() && directoryFile.listFiles().length > 0) {
                            checkForUserDefinedCategories = true;
                        }
                    }
                    if (regName == null) {
                        regName = inquiryURL;
                    }
                    if (publishURL == null && publishURLs != null && i < publishURLs.length && publishURLs[i] != null) {
                        publishURL = URLUtils.decode(publishURLs[i]);
                    }
                    propertyTable.put("inquiryURL", inquiryURL);
                    propertyTable.put("registryName", regName);
                    if (Validator.validateURL(publishURL)) {
                        propertyTable.put("publishURL", publishURL);
                    }
                    if (Validator.validateURL(registrationURL)) {
                        propertyTable.put("registrationURL", registrationURL);
                    }
                    directoryBuffer.setLength(0);
                    String encodedInquiryURL = URLUtils.encode(inquiryURL);
                    directoryBuffer.append(this.controller_.getServletEngineStateLocation()).append(encodedInquiryURL).append(".properties");
                    directoryFile = new File(directoryBuffer.toString());
                    if (directoryFile.exists()) {
                        try {
                            Properties p = new Properties();
                            FileInputStream fin = new FileInputStream(directoryFile);
                            p.load(fin);
                            fin.close();
                            directoryFile.delete();
                            String dataDirectory = p.getProperty("categoriesDirectory");
                            if (dataDirectory != null) {
                                propertyTable.put("categoriesDirectory", dataDirectory);
                            }
                            checkForUserDefinedCategories = true;
                        }
                        catch (IOException iOException) {
                            checkForUserDefinedCategories = false;
                        }
                    }
                    if (checkForUserDefinedCategories) {
                        propertyTable.put("checkUserDefinedCategories", Boolean.TRUE);
                    } else {
                        propertyTable.remove("checkUserDefinedCategories");
                    }
                    action.run();
                    RegistryElement regElement = (RegistryElement)this.navigatorManager_.getSelectedNode().getTreeElement();
                    Enumeration userDefinedCategories = regElement.getUserDefinedCategories();
                    if (userDefinedCategories != null && userDefinedCategories.hasMoreElements()) {
                        AddRegistryToUDDIPerspectiveAction action2 = new AddRegistryToUDDIPerspectiveAction(this.controller_);
                        String categoriesDirectory = regElement.getCategoriesDirectory();
                        if (categoriesDirectory != null) {
                            action2.linkCategoryModelsWithSavedData(userDefinedCategories, categoriesDirectory);
                        } else {
                            action2.linkCategoryModelsWithSavedData(regElement.getName(), userDefinedCategories);
                        }
                    }
                }
                ++i;
            }
            if (inquiryURLs.length > 0) {
                this.controller_.setCurrentPerspective(0);
            }
        }
    }

    private final void preloadServicesForRegistry(RegistryNode regNode, String[] serviceNames, String[] serviceKeys) {
        int regNodeId = regNode.getNodeId();
        int i = 0;
        while (i < serviceKeys.length) {
            this.navigatorManager_.setSelectedNodeId(regNodeId);
            RegFindServiceUUIDAction action = new RegFindServiceUUIDAction(this.controller_);
            Hashtable propertyTable = action.getPropertyTable();
            propertyTable.put("queryName", serviceNames[i]);
            propertyTable.put("uuidServiceKey", serviceKeys[i]);
            action.run();
            this.navigatorManager_.makeSelectedNodeVisible();
            ++i;
        }
    }

    public final void preloadServices(String[] inquiryURLs, String[] serviceNames, String[] serviceKeys) {
        if (serviceKeys != null && serviceNames != null && serviceNames.length == serviceKeys.length) {
            int i = 0;
            while (i < serviceKeys.length) {
                if (inquiryURLs != null) {
                    Hashtable<String, Boolean> inquiryURLsHash = new Hashtable<String, Boolean>();
                    int j = 0;
                    while (j < inquiryURLs.length) {
                        inquiryURLsHash.put(inquiryURLs[j], Boolean.TRUE);
                        ++j;
                    }
                    Node uddiMainNode = this.navigatorManager_.getRootNode();
                    Vector registryNodes = uddiMainNode.getChildNodes();
                    int k = 0;
                    while (k < registryNodes.size()) {
                        RegistryNode regNode = (RegistryNode)registryNodes.elementAt(k);
                        RegistryElement regElement = (RegistryElement)regNode.getTreeElement();
                        String existingRegistryInquiryURL = regElement.getInquiryURL();
                        if (inquiryURLsHash.get(existingRegistryInquiryURL) != null) {
                            this.preloadServicesForRegistry(regNode, serviceNames, serviceKeys);
                            inquiryURLsHash.remove(existingRegistryInquiryURL);
                        }
                        ++k;
                    }
                    Enumeration inquiryURLsEnum = inquiryURLsHash.keys();
                    while (inquiryURLsEnum.hasMoreElements()) {
                        String inquiryURL = (String)inquiryURLsEnum.nextElement();
                        this.preloadUDDIRegistries(new String[]{inquiryURL}, null);
                        RegistryNode regNode = (RegistryNode)this.navigatorManager_.getSelectedNode();
                        this.preloadServicesForRegistry(regNode, serviceNames, serviceKeys);
                    }
                }
                ++i;
            }
        }
    }

    public final void setCategoryTModelKey(String categoryTModelKey) {
        this.categoryTModelKey_ = categoryTModelKey;
    }

    public final String getCategoryTModelKey() {
        return this.categoryTModelKey_;
    }

    private final void initCategoryBrowser(CategoryModel categoryModel, NodeManager nodeManager) {
        TreeElement categoryRootElement = (TreeElement)categoryModel.getRootElement();
        RootCategoryNode rootCategoryNode = new RootCategoryNode(categoryRootElement, nodeManager);
        nodeManager.setRootNode(rootCategoryNode);
        rootCategoryNode.createChildren();
    }

    public final NodeManager getCategoryManager() {
        return (NodeManager)this.categoryManagers_.get(this.categoryTModelKey_);
    }

    public final NodeManager getCategoryManager(CategoryModel categoryModel) {
        String tModelKey = categoryModel.getTModelKey();
        NodeManager categoryManager = (NodeManager)this.categoryManagers_.get(tModelKey);
        if (categoryManager == null) {
            categoryManager = new NodeManager(this.controller_);
            this.initCategoryBrowser(categoryModel, categoryManager);
            this.categoryManagers_.put(tModelKey, categoryManager);
        }
        return categoryManager;
    }

    public final NodeManager getNavigatorManager() {
        return this.navigatorManager_;
    }

    @Override
    public final NodeManager getNodeManager() {
        return this.getNavigatorManager();
    }

    public final void setWSDLType(int wsdlType) {
        this.wsdlType_ = wsdlType;
    }

    public final int getWSDLType() {
        return this.wsdlType_;
    }

    @Override
    public final String getPerspectiveContentPage() {
        return "uddi/uddi_perspective_content.jsp";
    }

    @Override
    public final int getPerspectiveId() {
        return 0;
    }

    @Override
    public final String getFramesetsFile() {
        return "uddi/scripts/uddiframesets.jsp";
    }

    @Override
    public final String getProcessFramesetsForm() {
        return "uddi/forms/ProcessUDDIFramesetsForm.jsp";
    }

    @Override
    public final String getPanesFile() {
        return "uddi/scripts/uddipanes.jsp";
    }

    @Override
    public final String getTreeContentVar() {
        return "navigatorContent";
    }

    @Override
    public final String getTreeContentPage() {
        return "uddi/navigator_content.jsp";
    }

    @Override
    public final String getPropertiesContainerVar() {
        return "propertiesContainer";
    }

    @Override
    public final String getPropertiesContainerPage() {
        return "uddi/properties_container.jsp";
    }

    @Override
    public final String getStatusContentVar() {
        return "statusContent";
    }

    @Override
    public final String getStatusContentPage() {
        return "uddi/status_content.jsp";
    }

    public final String getSavePerspectiveActionLink() {
        return "";
    }

    public final String getPerspectiveContentFramesetCols() {
        return this.perspectiveContentFramesetCols_;
    }

    public final void setPerspectiveContentFramesetCols(String cols) {
        this.perspectiveContentFramesetCols_ = cols;
    }

    public final void setSavedPerspectiveContentFramesetCols(String cols) {
        this.savedPerspectiveContentFramesetCols_ = cols;
    }

    public final String getSavedPerspectiveContentFramesetCols() {
        return this.savedPerspectiveContentFramesetCols_;
    }

    public final String getActionsContainerFramesetRows() {
        return this.actionsContainerFramesetRows_;
    }

    public final void setActionsContainerFramesetRows(String rows) {
        this.actionsContainerFramesetRows_ = rows;
    }

    public final void setSavedActionsContainerFramesetRows(String rows) {
        this.savedActionsContainerFramesetRows_ = rows;
    }

    public final String getSavedActionsContainerFramesetRows() {
        return this.savedActionsContainerFramesetRows_;
    }

    @Override
    public final String getSwitchPerspectiveFormActionLink(int targetPerspectiveId, boolean forHistory) {
        return SwitchPerspectiveFromUDDIAction.getFormActionLink(targetPerspectiveId, forHistory);
    }
}

