/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ReadQuery;

public class MapEntryExpression
extends QueryKeyExpression {
    protected boolean returnMapEntry = false;

    public MapEntryExpression(Expression base) {
        this();
        this.baseExpression = base;
    }

    public MapEntryExpression() {
        this.shouldQueryToManyRelationship = true;
        this.hasQueryKey = true;
        this.hasMapping = false;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        return ((DataExpression)this.getBaseExpression()).aliasForTable(table);
    }

    public void returnMapEntry() {
        this.returnMapEntry = true;
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        Expression result = null;
        result = this.returnMapEntry ? newLocalBase.mapEntry() : newLocalBase.mapKey();
        result.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return result;
    }

    @Override
    public Expression rebuildOn(Expression oldBase, Expression newBase) {
        if (this == oldBase) {
            return newBase;
        }
        Expression newLocalBase = ((QueryKeyExpression)this.getBaseExpression()).rebuildOn(oldBase, newBase);
        Expression result = null;
        result = this.returnMapEntry ? newLocalBase.mapEntry() : newLocalBase.mapKey();
        result.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return result;
    }

    @Override
    public String descriptionOfNodeType() {
        if (this.returnMapEntry) {
            return "MapEntry";
        }
        return "MapKey";
    }

    @Override
    public Expression existingDerivedTable(DatabaseTable table) {
        if (this.baseExpression.isDataExpression()) {
            return ((DataExpression)this.baseExpression).existingDerivedTable(table);
        }
        return super.existingDerivedTable(table);
    }

    @Override
    public List<DatabaseTable> getOwnedTables() {
        return null;
    }

    @Override
    public ClassDescriptor getDescriptor() {
        if (this.isAttribute()) {
            return null;
        }
        if (this.descriptor == null) {
            ForeignReferenceQueryKey queryKey = (ForeignReferenceQueryKey)this.getQueryKeyOrNull();
            if (queryKey != null) {
                this.descriptor = this.getSession().getDescriptor(queryKey.getReferenceClass());
                return this.descriptor;
            }
            if (this.getMapping() == null) {
                throw QueryException.invalidQueryKeyInExpression(this);
            }
            this.descriptor = this.getMapping().getContainerPolicy().getDescriptorForMapKey();
            if (this.getMapping().isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(this.getMapping(), this.descriptor);
            }
        }
        return this.descriptor;
    }

    @Override
    public DatabaseField getField() {
        if (!this.isAttribute()) {
            return null;
        }
        DatabaseField field = this.getInterfaceContainerPolicy().getDirectKeyField(this.getMapping());
        return field;
    }

    @Override
    public Vector getFields() {
        Vector<DatabaseField> result = new Vector<DatabaseField>();
        InterfaceContainerPolicy icp = this.getInterfaceContainerPolicy();
        if (this.returnMapEntry || !icp.isMappedKeyMapPolicy()) {
            result.addAll(this.getBaseExpression().getFields());
        } else if (this.isAttribute()) {
            DatabaseField field = this.getField();
            if (field != null) {
                result.add(field);
            }
        } else {
            result.addAll(this.getInterfaceContainerPolicy().getAdditionalFieldsForJoin(this.getMapping()));
        }
        return result;
    }

    @Override
    public List<DatabaseField> getSelectionFields(ReadQuery query) {
        ArrayList<DatabaseField> result = new ArrayList<DatabaseField>();
        InterfaceContainerPolicy icp = this.getInterfaceContainerPolicy();
        if (this.returnMapEntry || !icp.isMappedKeyMapPolicy()) {
            result.addAll(this.getBaseExpression().getSelectionFields(query));
        } else if (this.isAttribute()) {
            DatabaseField field = this.getField();
            if (field != null) {
                result.add(field);
            }
        } else {
            result.addAll(this.getInterfaceContainerPolicy().getAdditionalFieldsForJoin(this.getMapping()));
        }
        return result;
    }

    @Override
    public CollectionMapping getMapping() {
        return (CollectionMapping)((QueryKeyExpression)this.getBaseExpression()).getMapping();
    }

    @Override
    public QueryKey getQueryKeyOrNull() {
        if (!this.hasQueryKey) {
            return null;
        }
        InterfaceContainerPolicy cp = this.getInterfaceContainerPolicy();
        if (this.queryKey == null) {
            if (this.returnMapEntry) {
                return null;
            }
            this.queryKey = cp.createQueryKeyForMapKey();
        }
        return this.queryKey;
    }

    @Override
    public boolean isAttribute() {
        if (this.isAttributeExpression == null) {
            if (this.returnMapEntry) {
                return false;
            }
            InterfaceContainerPolicy containerPolicy = this.getInterfaceContainerPolicy();
            return containerPolicy.isMapKeyAttribute();
        }
        return this.isAttributeExpression;
    }

    @Override
    public boolean isMapEntryExpression() {
        return true;
    }

    private InterfaceContainerPolicy getInterfaceContainerPolicy() {
        CollectionMapping mapping = this.getMapping();
        if (mapping == null) {
            throw QueryException.noMappingForMapEntryExpression(this.getBaseExpression());
        }
        if (!((DatabaseMapping)mapping).isCollectionMapping()) {
            throw QueryException.mapEntryExpressionForNonCollection(this.getBaseExpression(), this.getMapping());
        }
        InterfaceContainerPolicy cp = null;
        try {
            cp = (InterfaceContainerPolicy)this.getMapping().getContainerPolicy();
        }
        catch (ClassCastException e) {
            throw QueryException.mapEntryExpressionForNonMap(this.getBaseExpression(), this.getMapping());
        }
        return cp;
    }

    @Override
    public Expression mappingCriteria(Expression base) {
        return null;
    }

    public boolean shouldReturnMapEntry() {
        return this.returnMapEntry;
    }

    @Override
    public void validateNode() {
        if (this.getQueryKeyOrNull() == null && this.getMapping() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        if (!this.getMapping().isCollectionMapping()) {
            throw QueryException.mapEntryExpressionForNonCollection(this.getBaseExpression(), this.getMapping());
        }
        ContainerPolicy cp = this.getMapping().getContainerPolicy();
        if (cp == null || !cp.isMapPolicy()) {
            throw QueryException.mapEntryExpressionForNonMap(this.getBaseExpression(), this.getMapping());
        }
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.descriptionOfNodeType());
    }
}

