/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SynchronizedIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Object mutex;

    public SynchronizedIterator(Iterator<? extends E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.mutex = this;
    }

    public SynchronizedIterator(Iterator<? extends E> iterator, Object mutex) {
        if (iterator == null || mutex == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.mutex;
        synchronized (object) {
            return this.iterator.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        Object object = this.mutex;
        synchronized (object) {
            return this.iterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this.mutex;
        synchronized (object) {
            this.iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return ObjectTools.toString((Object)this, this.iterator);
        }
    }
}

