/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.osgi;

import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class BundleReference {
    private String id;
    private VersionRange versionRange;

    public BundleReference(String id, VersionRange versionRange) {
        this.id = id;
        this.versionRange = versionRange;
    }

    public String getBundleId() {
        return this.id;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public boolean isResolvable() {
        return this.getBundles() != null;
    }

    public Bundle getBundle() {
        Bundle[] bundles = this.getBundles();
        if (bundles == null) {
            return null;
        }
        TreeMap<Version, Bundle> bundlesByVersion = new TreeMap<Version, Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Version version = BundleReference.getBundleVersion(bundle);
            if (version != null) {
                bundlesByVersion.put(version, bundle);
            }
            ++n2;
        }
        if (bundlesByVersion.isEmpty()) {
            return null;
        }
        return (Bundle)bundlesByVersion.get(bundlesByVersion.lastKey());
    }

    private Bundle[] getBundles() {
        return Platform.getBundles((String)this.id, this.versionRange == null ? null : this.versionRange.toString());
    }

    private static Version getBundleVersion(Bundle bundle) {
        String versionString = (String)bundle.getHeaders().get("Bundle-Version");
        return versionString == null ? null : new Version(versionString);
    }
}

