/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.Trace;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ = "obj16/";
    private static final String URL_WIZBAN = "wizban/";
    public static final String IMG_WIZARD = "wizard";
    public static final String IMG_EXTENSION = "extension";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = Activator.getDefault().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not set icon base URL", e);
        }
    }

    private ImageResource() {
    }

    protected static void dispose() {
    }

    public static Image getImage(String key) {
        Image image;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((image = imageRegistry.get(key)) == null) {
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor id;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((id = imageDescriptors.get(key)) != null) {
            return id;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    protected static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage(IMG_WIZARD, "wizban/install_wiz.gif");
        ImageResource.registerImage(IMG_EXTENSION, "obj16/iu_obj.gif");
        PlatformUI.getWorkbench().getProgressService().registerIconForFamily(ImageResource.getImageDescriptor(IMG_EXTENSION), (Object)"org.eclipse.wst.server.discovery");
    }

    private static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error registering image " + key + " from " + partialURL, e);
        }
    }
}

