/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsflibraryconfiguration;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReference;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReferenceServerSupplied;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferenceFacadeFactory;

public final class JSFLibraryConfigurationHelper {
    public static final String JSF_LIBRARY_CP_CONTAINER_ID = "org.eclipse.jst.jsf.core.internal.jsflibrarycontainer";

    public static Collection<JSFLibraryReference> getJSFLibraryReferences(IProject project) {
        HashSet<JSFLibraryReference> results = new HashSet<JSFLibraryReference>();
        IJavaProject jproj = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] entries = jproj.getRawClasspath();
            boolean foundImpl = false;
            int i = 0;
            while (i < entries.length) {
                JSFLibraryReference ref = JSFLibraryReferenceFacadeFactory.create(entries[i]);
                if (ref != null) {
                    results.add(ref);
                    if (ref.isJSFImplementation()) {
                        foundImpl = true;
                    }
                }
                ++i;
            }
            if (!foundImpl) {
                results.add(JSFLibraryReferenceFacadeFactory.createServerSuppliedJSFLibRef());
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occurred calling getJSFLibraryReferences for " + project.getName());
        }
        return results;
    }

    public static boolean isJSFLibraryContainer(IClasspathEntry cpEntry) {
        if (cpEntry.getEntryKind() != 5) {
            return false;
        }
        IPath path = cpEntry.getPath();
        return path != null && path.segmentCount() == 2 && JSF_LIBRARY_CP_CONTAINER_ID.equals(path.segment(0));
    }

    public static boolean isConfiguredForSystemSuppliedImplementation(IProject project) {
        Collection<JSFLibraryReference> refs = JSFLibraryConfigurationHelper.getJSFLibraryReferences(project);
        for (JSFLibraryReference ref : refs) {
            if (!(ref instanceof JSFLibraryReferenceServerSupplied)) continue;
            return true;
        }
        return false;
    }
}

