/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.RemoveSubNodeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFHtmlOutputTextConverterSection
extends BaseCustomSection {
    private Table _convertTable;
    private TableViewer _convertViewer;
    private Button _convertAddButton;
    private Button _convertRemoveButton;
    private CCombo _convertTypeCombo;
    private static final String[] CONVERTTYPES = new String[]{"DateTime", "Number"};

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        this.createConvertPart(factory, top);
    }

    private void createConvertPart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._convertTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        this._convertTable.setHeaderVisible(true);
        this._convertTable.setLayoutData((Object)data);
        this._convertTable.setLinesVisible(true);
        TableColumn convertColumn = new TableColumn(this._convertTable, 0);
        convertColumn.setText(SectionResources.getString("JSFHtmlOutputTextSection.Converter"));
        convertColumn.setWidth(100);
        this._convertViewer = new TableViewer(this._convertTable);
        this._convertViewer.setContentProvider((IContentProvider)new ConvertCotentLabelProvider());
        this._convertViewer.setLabelProvider((IBaseLabelProvider)new ConvertCotentLabelProvider());
        this._convertViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlOutputTextConverterSection.this.gotoNode((Node)node);
                }
            }
        });
        this._convertViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlOutputTextConverterSection.this.updateConvertButtonStatus();
            }
        });
        this._convertTypeCombo = factory.createCCombo(other, 8);
        this._convertTypeCombo.setItems(CONVERTTYPES);
        this._convertTypeCombo.select(0);
        data = new GridData(256);
        this._convertTypeCombo.setLayoutData((Object)data);
        this._convertAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlOutputTextSection.Add"), 0);
        data = new GridData(256);
        this._convertAddButton.setLayoutData((Object)data);
        this._convertAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap attributes = new HashMap();
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlOutputTextSection.CommandLabel.AddSubTag"), JSFHtmlOutputTextConverterSection.this._element, "convert" + JSFHtmlOutputTextConverterSection.this._convertTypeCombo.getText(), "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlOutputTextConverterSection.this._convertViewer.refresh();
                JSFHtmlOutputTextConverterSection.this.updateConvertButtonStatus();
            }
        });
        this._convertRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlOutputTextSection.Remove"), 0);
        data = new GridData(256);
        this._convertRemoveButton.setLayoutData((Object)data);
        this._convertRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlOutputTextConverterSection.this._convertViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlOutputTextSection.CommandLabel.RemoveSubTag"), JSFHtmlOutputTextConverterSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlOutputTextConverterSection.this._convertViewer.refresh();
                    JSFHtmlOutputTextConverterSection.this.updateConvertButtonStatus();
                }
            }
        });
    }

    private void updateConvertButtonStatus() {
        this._convertAddButton.setEnabled(true);
        this._convertRemoveButton.setEnabled(true);
        ISelection selection = this._convertViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this._convertRemoveButton.setEnabled(false);
        }
        if (this._convertTable.getItemCount() == 0) {
            this._convertRemoveButton.setEnabled(false);
        }
        if (this._convertTable.getItemCount() > 0) {
            this._convertAddButton.setEnabled(false);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._convertViewer.setInput((Object)this._element);
        this.updateConvertButtonStatus();
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._convertViewer != null && !this._convertViewer.getControl().isDisposed()) {
            this._convertViewer.refresh();
        }
    }

    private class ConvertCotentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ConvertCotentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlOutputTextConverterSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("convert") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)element;
                String nodeName = node.getNodeName();
                switch (columnIndex) {
                    case 0: {
                        result = nodeName;
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

