/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.utils.StatusUtils;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.jst.ws.jaxws.utils.operation.IOperationRunner;

public class OperationInJobRunner
implements IOperationRunner {
    private final String jobName;
    private final ISchedulingRule jobRule;
    private final ILogger logger;

    public OperationInJobRunner(String jobName, ISchedulingRule jobRule) {
        this.jobName = jobName;
        this.jobRule = jobRule;
        this.logger = new Logger();
    }

    @Override
    public void run(final IRunnableWithProgress runnable) {
        Job job = new Job(this.jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                }
                catch (InvocationTargetException e) {
                    OperationInJobRunner.this.logger.logError(e.getMessage(), e);
                    return StatusUtils.statusError(e.getMessage(), e);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(this.jobRule);
        job.schedule();
    }
}

