/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.wsdd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.axis.model.wsdd.InternalParameterMode;

public final class ParameterMode
extends InternalParameterMode {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    public static final ParameterMode IN_LITERAL = new ParameterMode(1, "IN", "IN");
    public static final ParameterMode OUT_LITERAL = new ParameterMode(2, "OUT", "OUT");
    public static final ParameterMode INOUT_LITERAL = new ParameterMode(3, "INOUT", "INOUT");
    private static final ParameterMode[] VALUES_ARRAY = new ParameterMode[]{IN_LITERAL, OUT_LITERAL, INOUT_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ParameterMode get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ParameterMode result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ParameterMode getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ParameterMode result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ParameterMode get(int value) {
        switch (value) {
            case 1: {
                return IN_LITERAL;
            }
            case 2: {
                return OUT_LITERAL;
            }
            case 3: {
                return INOUT_LITERAL;
            }
        }
        return null;
    }

    private ParameterMode(int value, String name, String literal) {
        super(value, name, literal);
    }
}

