/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.libval;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.libval.JaxbLibraryValidatorTools;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JaxbJreLibraryValidator
implements LibraryValidator {
    public IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        JaxbLibraryProviderInstallOperationConfig jaxbConfig = (JaxbLibraryProviderInstallOperationConfig)config;
        if (!jaxbConfig.getJaxbPlatformConfig().getGroupConfig().getId().equals("generic")) {
            return JptJaxbCorePlugin.instance().buildErrorStatus(JptJaxbCoreMessages.JRE_LIBRARY_VALIDATOR_INVALID_PLATFORM);
        }
        IProjectFacetVersion jaxbVersion = config.getProjectFacetVersion();
        IProjectFacetVersion javaVersion = LibraryValidatorTools.getJavaFacetVersion((JptLibraryProviderInstallOperationConfig)jaxbConfig);
        IProjectFacetVersion javaJaxbVersion = JaxbLibraryValidatorTools.findJavaJaxbVersion(jaxbConfig);
        IProjectFacetVersion jreJaxbVersion = JaxbLibraryValidatorTools.findJreJaxbVersion(jaxbConfig);
        if (jreJaxbVersion == null || jreJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
            return JptJaxbCorePlugin.instance().buildErrorStatus(JptJaxbCoreMessages.JRE_LIBRARY_VALIDATOR_INVALID_JAVA_LIBRARY, new Object[]{jaxbVersion.getVersionString()});
        }
        if (javaJaxbVersion == null || javaJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
            return JptJaxbCorePlugin.instance().buildStatus(2, JptJaxbCoreMessages.JRE_LIBRARY_VALIDATOR_INVALID_JAVA_FACET, new Object[]{javaVersion.getVersionString(), jaxbVersion.getVersionString()});
        }
        return Status.OK_STATUS;
    }
}

