/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.keyword.contentassist;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class KeywordProposal
implements ICompletionProposal,
IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private final String keywordName;
    private IRegion fSelectedRegion;
    private final IRegion fRegion;

    public KeywordProposal(String keywordName, IRegion fRegion) {
        this.keywordName = keywordName;
        this.fRegion = fRegion;
    }

    public final void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.keywordName;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.keywordName;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.fRegion.getOffset();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            document.replace(this.fRegion.getOffset(), offset - this.fRegion.getOffset(), this.keywordName);
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        this.fSelectedRegion = new Region(this.fRegion.getOffset() + this.keywordName.length(), 0);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.fRegion.getOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.keywordName.toLowerCase().startsWith(content.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    @Override
    public int getRelevance() {
        return 0;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)"Keyword Proposal Error", (String)e.getMessage());
    }
}

