/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SubTypesOfSingleton
extends TypeSet {
    private final TType fUpperBound;
    private EnumeratedTypeSet fEnumCache = null;

    protected SubTypesOfSingleton(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull((Object)t);
        this.fUpperBound = t;
    }

    @Override
    public boolean isUniverse() {
        return this.fUpperBound.equals(this.getJavaLangObject());
    }

    @Override
    public TypeSet makeClone() {
        return this;
    }

    @Override
    public TypeSet subTypes() {
        return this;
    }

    @Override
    public TypeSet specialCasesIntersectedWith(TypeSet other) {
        if (other.isSingleton() && other.anyMember().equals(this.fUpperBound)) {
            return other;
        }
        if (other instanceof SubTypesOfSingleton) {
            SubTypesOfSingleton otherSub = (SubTypesOfSingleton)other;
            if (TTypes.canAssignTo(otherSub.fUpperBound, this.fUpperBound)) {
                return otherSub;
            }
            if (TTypes.canAssignTo(this.fUpperBound, otherSub.fUpperBound)) {
                return this;
            }
        } else if (other.hasUniqueLowerBound()) {
            TType otherLower = other.uniqueLowerBound();
            if (otherLower.equals(this.fUpperBound)) {
                return new SingletonTypeSet(this.fUpperBound, this.getTypeSetEnvironment());
            }
            if (otherLower != this.fUpperBound && TTypes.canAssignTo(this.fUpperBound, otherLower) || !TTypes.canAssignTo(otherLower, this.fUpperBound)) {
                return this.getTypeSetEnvironment().getEmptyTypeSet();
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public TypeSet upperBound() {
        return new SingletonTypeSet(this.fUpperBound, this.getTypeSetEnvironment());
    }

    @Override
    public TypeSet lowerBound() {
        EnumeratedTypeSet e = this.enumerate();
        return e.lowerBound();
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return false;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return true;
    }

    @Override
    public TType uniqueLowerBound() {
        TypeSet lowerBound = this.lowerBound();
        return lowerBound.anyMember();
    }

    @Override
    public TType uniqueUpperBound() {
        return this.fUpperBound;
    }

    @Override
    public boolean contains(TType t) {
        if (t.equals(this.fUpperBound)) {
            return true;
        }
        return TTypes.canAssignTo(t, this.fUpperBound);
    }

    @Override
    public boolean containsAll(TypeSet other) {
        if (this.isUniverse()) {
            return true;
        }
        if (other instanceof SubTypesOfSingleton) {
            SubTypesOfSingleton otherSub = (SubTypesOfSingleton)other;
            return TTypes.canAssignTo(otherSub.fUpperBound, this.fUpperBound);
        }
        if (other instanceof SubTypesSet) {
            SubTypesSet otherSub = (SubTypesSet)other;
            TypeSet otherUpperBounds = otherSub.upperBound();
            Iterator iter = otherUpperBounds.iterator();
            while (iter.hasNext()) {
                TType t = (TType)iter.next();
                if (TTypes.canAssignTo(t, this.fUpperBound)) continue;
                return false;
            }
            return true;
        }
        Iterator iter = other.iterator();
        while (iter.hasNext()) {
            TType t = (TType)iter.next();
            if (TTypes.canAssignTo(t, this.fUpperBound)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    private TType getElementTypeOf(TType t) {
        if (t instanceof ArrayType) {
            return ((ArrayType)t).getElementType();
        }
        return t;
    }

    @Override
    public boolean isSingleton() {
        return this.getElementTypeOf(this.fUpperBound).getSubTypes().length == 0;
    }

    @Override
    public TType anyMember() {
        return this.fUpperBound;
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            if (this.fUpperBound instanceof ArrayType) {
                ArrayType at = (ArrayType)this.fUpperBound;
                this.fEnumCache = EnumeratedTypeSet.makeArrayTypesForElements(TTypes.getAllSubTypesIterator(at.getComponentType()), this.getTypeSetEnvironment());
            } else {
                this.fEnumCache = new EnumeratedTypeSet(TTypes.getAllSubTypesIterator(this.fUpperBound), this.getTypeSetEnvironment());
            }
            this.fEnumCache.add(this.fUpperBound);
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SubTypesOfSingleton)) {
            return false;
        }
        SubTypesOfSingleton other = (SubTypesOfSingleton)o;
        return other.fUpperBound.equals(this.fUpperBound);
    }

    @Override
    public String toString() {
        return "<" + this.fID + ": subTypes(" + this.fUpperBound.getPrettySignature() + ")>";
    }
}

