/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceBundleProvider;
import org.eclipse.jst.jsf.common.metadata.internal.Messages;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.BooleanValue;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.StringValue;
import org.eclipse.osgi.util.NLS;

public class TraitValueHelper2 {
    private static final String KEY_NOT_FOUND = Messages.Key_not_found;

    public EClass getValueType(Trait trait) {
        if (trait == null) {
            return null;
        }
        if (trait.getValue() != null) {
            return trait.getValue().eClass();
        }
        return null;
    }

    public Object getValue(Trait trait) {
        if (trait == null) {
            return null;
        }
        if (trait.getValue() == null) {
            return null;
        }
        if (trait.getValue() instanceof StringValue) {
            return ((StringValue)trait.getValue()).getValue();
        }
        if (trait.getValue() instanceof SimpleAnyType) {
            return ((SimpleAnyType)trait.getValue()).getRawValue();
        }
        if (trait.getValue() instanceof AnyType) {
            AnyType any = (AnyType)trait.getValue();
            FeatureMap map = any.getMixed();
            return this.getTextValueFromFeatureMap(map);
        }
        if (trait.getValue().eIsProxy() && trait.getValue() instanceof BasicEObjectImpl) {
            BasicEObjectImpl o = (BasicEObjectImpl)trait.getValue();
            return o.eProxyURI().toString();
        }
        return trait.getValue();
    }

    protected String getTextValueFromFeatureMap(FeatureMap map) {
        for (FeatureMap.Entry entry : map) {
            if (!entry.getEStructuralFeature().getName().equals("text")) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public String getValueAsString(Trait trait) {
        Object val = this.getValue(trait);
        if (val instanceof String) {
            return this.getNLSValue(trait, (String)val);
        }
        if (val instanceof BooleanValue) {
            return String.valueOf(((BooleanValue)val).isTrue());
        }
        return null;
    }

    public synchronized List getValueAsListOfStrings(Trait trait) {
        ArrayList<String> ret = new ArrayList<String>();
        if (trait.getValue() instanceof ListOfValues) {
            for (Object o : trait.getValue().eContents()) {
                if (!(o instanceof SimpleAnyType)) continue;
                SimpleAnyType sat = (SimpleAnyType)o;
                String rawValue = this.getTextValueFromFeatureMap(sat.getMixed());
                String nlsValue = this.getNLSValue(trait, rawValue);
                ret.add(nlsValue);
            }
        } else {
            String o = this.getValueAsString(trait);
            if (o != null) {
                ret.add(o);
            }
        }
        return ret;
    }

    public String getNLSValue(Trait trait, String rawValue) {
        String key;
        String result = rawValue;
        if (rawValue.startsWith("%") && !rawValue.startsWith("%%") && (result = this.getNLSPropertyValue(trait, key = rawValue.substring(1))) == null) {
            result = rawValue;
        }
        return result == null ? null : result.trim();
    }

    protected String getNLSPropertyValue(Trait trait, String key) {
        try {
            ResourceBundle resourceBundle_;
            IMetaDataSourceModelProvider provider = trait.getSourceModelProvider();
            IResourceBundleProvider resourceBundleProvider = (IResourceBundleProvider)provider.getAdapter(IResourceBundleProvider.class);
            if (resourceBundleProvider != null && (resourceBundle_ = resourceBundleProvider.getResourceBundle()) != null) {
                String replVal = resourceBundle_.getString(key);
                return replVal;
            }
            return key;
        }
        catch (MissingResourceException e) {
            JSFCommonPlugin.log(e, NLS.bind((String)Messages.MissingResource_exception, (Object[])new String[]{key}));
            return key + KEY_NOT_FOUND;
        }
    }

    public boolean getValueAsBoolean(Trait trait) {
        if (trait != null && trait.getValue() instanceof BooleanValue) {
            return ((BooleanValue)trait.getValue()).isTrue();
        }
        String val = this.getValueAsString(trait);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }
}

