/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TrackingModeType implements Enumerator
{
    COOKIE(0, "COOKIE", "COOKIE"),
    URL(1, "URL", "URL"),
    SSL(2, "SSL", "SSL");

    public static final int COOKIE_VALUE = 0;
    public static final int URL_VALUE = 1;
    public static final int SSL_VALUE = 2;
    private static final TrackingModeType[] VALUES_ARRAY;
    public static final List<TrackingModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TrackingModeType[]{COOKIE, URL, SSL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TrackingModeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TrackingModeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TrackingModeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TrackingModeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TrackingModeType get(int value) {
        switch (value) {
            case 0: {
                return COOKIE;
            }
            case 1: {
                return URL;
            }
            case 2: {
                return SSL;
            }
        }
        return null;
    }

    private TrackingModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

