/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.PageDesignerTraceOptions;
import org.eclipse.jst.pagedesigner.converter.ConverterFacRegistryReader;
import org.eclipse.jst.pagedesigner.converter.DefaultUnknownTagConverter;
import org.eclipse.jst.pagedesigner.converter.DumTagConverter;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.html.HTMLConverterFactory;
import org.eclipse.jst.pagedesigner.converter.jsp.JSPConverterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;

public class ConverterFactoryRegistry {
    List _factories = new ArrayList();
    private static ConverterFactoryRegistry _instance;

    private ConverterFactoryRegistry() {
        List<IConverterFactory> facs = ConverterFacRegistryReader.getAllHandlers();
        if (facs != null) {
            for (IConverterFactory fac : facs) {
                this.addFactory(fac);
            }
        }
        this._factories.add(new JSPConverterFactory());
        this._factories.add(new HTMLConverterFactory());
    }

    public void addFactory(IConverterFactory fac) {
        this._factories.add(fac);
    }

    public ITagConverter createTagConverter(Element ele, int mode, IDOMDocument targetDocument) {
        ITagConverter converter = this.internalCreateTagConverter(ele, mode);
        if (converter != null) {
            converter.setDestDocument(targetDocument);
        }
        return converter;
    }

    protected final ITagConverter internalCreateTagConverter(Element ele, int mode) {
        ITagConverter converter;
        String facuri;
        IConverterFactory fac;
        String uri = CMUtil.getElementNamespaceURI((Element)ele);
        int i = 0;
        int size = this._factories.size();
        while (i < size) {
            fac = (IConverterFactory)this._factories.get(i);
            facuri = fac.getSupportedURI();
            if (facuri != null && facuri.equals(uri) && (converter = fac.createConverter(ele, mode)) != null) {
                if (PageDesignerTraceOptions.TRACE_CONVERTERSELECT) {
                    PageDesignerTraceOptions.log("ConverterFactoryRegistry: first loop, " + String.format("Selected converter %s for uri=%s, tagname=%s", converter.getClass().getName(), uri, ele.getLocalName()));
                }
                return converter;
            }
            ++i;
        }
        i = 0;
        size = this._factories.size();
        while (i < size) {
            fac = (IConverterFactory)this._factories.get(i);
            facuri = fac.getSupportedURI();
            if (facuri == null && (converter = fac.createConverter(ele, mode)) != null) {
                if (PageDesignerTraceOptions.TRACE_CONVERTERSELECT) {
                    PageDesignerTraceOptions.log("ConverterFactoryRegistry: second loop, " + String.format("Selected converter %s for uri=%s, tagname=%s", converter.getClass().getName(), uri, ele.getLocalName()));
                }
                return converter;
            }
            ++i;
        }
        if (uri == null || "html".equals(uri)) {
            if (PageDesignerTraceOptions.TRACE_CONVERTERSELECT) {
                PageDesignerTraceOptions.log("ConverterFactoryRegistry: factory not found, " + String.format("Selected DumTagConverter for uri=%s, tagname=%s", uri, ele.getLocalName()));
            }
            return new DumTagConverter(ele);
        }
        CMElementDeclaration decl = CMUtil.getElementDeclaration((Element)ele);
        if (decl == null) {
            if (PageDesignerTraceOptions.TRACE_CONVERTERSELECT) {
                PageDesignerTraceOptions.log("ConverterFactoryRegistry: factory and decl not found, " + String.format("Selected DumTagConverter for uri=%s, tagname=%s", uri, ele.getLocalName()));
            }
            return new DumTagConverter(ele);
        }
        int contentType = decl.getContentType();
        if (contentType == 1) {
            if (PageDesignerTraceOptions.TRACE_CONVERTERSELECT) {
                PageDesignerTraceOptions.log("ConverterFactoryRegistry: factory not found, content is EMPTY, " + String.format("Selected HiddenTagConverter with UnknownImage for uri=%s, tagname=%s", uri, ele.getLocalName()));
            }
            return new HiddenTagConverter(ele, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ConverterFactoryRegistry.getUnknownImage();
                }
            });
        }
        if (PageDesignerTraceOptions.TRACE_CONVERTERSELECT) {
            PageDesignerTraceOptions.log("ConverterFactoryRegistry: fall-through to default case, " + String.format("Selected DefaultUnknownTagConverter with UnknownImage for uri=%s, tagname=%s", uri, ele.getLocalName()));
        }
        return new DefaultUnknownTagConverter(ele, mode);
    }

    private static Image getUnknownImage() {
        return JSFUICommonPlugin.getDefault().getImage("PD_Palette_Default.gif");
    }

    public static synchronized ConverterFactoryRegistry getInstance() {
        if (_instance == null) {
            _instance = new ConverterFactoryRegistry();
        }
        return _instance;
    }
}

