/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.FunctionScopeExtension;
import org.eclipse.wst.jsdt.chromium.JsArray;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.ScopeRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.FunctionValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsObjectBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsScopeImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.SubpropertiesMirror;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public class JsFunctionImpl
extends JsObjectBase<JsObjectBase.BasicPropertyData>
implements JsFunction {
    private volatile TextStreamPosition openParenPosition = null;
    public static final FunctionScopeExtension FUNCTION_SCOPE_EXTENSION = new FunctionScopeExtension(){

        @Override
        public List<? extends JsScope> getScopes(JsFunction function) throws MethodIsBlockingException {
            JsFunctionImpl functionImpl = (JsFunctionImpl)function;
            return functionImpl.getVariableScopes();
        }
    };

    JsFunctionImpl(ValueLoader valueLoader, ValueMirror valueState) {
        super(valueLoader, valueState);
    }

    @Override
    public Script getScript() throws MethodIsBlockingException {
        FunctionValueHandle functionValueHandle = this.getAdditionalPropertyData();
        Long scriptId = functionValueHandle.scriptId();
        if (scriptId == null) {
            return null;
        }
        DebugSession debugSession = this.getInternalContext().getDebugSession();
        return debugSession.getScriptManager().findById(scriptId);
    }

    private List<? extends JsScope> getVariableScopes() {
        List<ScopeRef> rawScopes = this.getAdditionalPropertyData().scopes();
        ArrayList result = new ArrayList(rawScopes.size());
        for (ScopeRef scopeRef : rawScopes) {
            result.add(JsScopeImpl.create(JsScopeImpl.Host.create(this), scopeRef));
        }
        return result;
    }

    @Override
    public TextStreamPosition getOpenParenPosition() throws MethodIsBlockingException {
        if (this.openParenPosition == null) {
            final FunctionValueHandle functionValueHandle = this.getAdditionalPropertyData();
            this.openParenPosition = new TextStreamPosition(){

                @Override
                public int getOffset() {
                    return this.castLongToInt(functionValueHandle.position(), -1);
                }

                @Override
                public int getLine() {
                    return this.castLongToInt(functionValueHandle.line(), -1);
                }

                @Override
                public int getColumn() {
                    return this.castLongToInt(functionValueHandle.column(), -1);
                }

                private int castLongToInt(Long objValue, int defaultValue) {
                    if (objValue == null) {
                        return defaultValue;
                    }
                    return objValue.intValue();
                }
            };
        }
        return this.openParenPosition;
    }

    private FunctionValueHandle getAdditionalPropertyData() throws MethodIsBlockingException {
        SubpropertiesMirror subpropertiesMirror = this.getBasicPropertyData(false).getSubpropertiesMirror();
        return (FunctionValueHandle)subpropertiesMirror.getAdditionalPropertyData();
    }

    @Override
    public JsArray asArray() {
        return null;
    }

    @Override
    public JsFunction asFunction() {
        return this;
    }

    @Override
    protected JsObjectBase.BasicPropertyData wrapBasicData(JsObjectBase.BasicPropertyData basicPropertyData) {
        return basicPropertyData;
    }

    @Override
    protected JsObjectBase.BasicPropertyData unwrapBasicData(JsObjectBase.BasicPropertyData additionalPropertyStore) {
        return additionalPropertyStore;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[JsFunction: type=").append((Object)this.getType());
        try {
            for (JsVariable jsVariable : this.getProperties()) {
                result.append(',').append(jsVariable);
            }
        }
        catch (MethodIsBlockingException methodIsBlockingException) {
            return "[JsObject: Exception in retrieving data]";
        }
        result.append(']');
        return result.toString();
    }
}

