/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import org.eclipse.wst.jsdt.chromium.Version;

public class V8VersionFeatures {
    private static final Version ACCURATE_RUNNING_FIELD = new Version(1, 3, 16);
    private static final Version REG_EXP_BREAKPOINT = new Version(3, 4, 7);
    private static final Version FUNCTION_SCOPE = new Version(3, 10, 7);
    private static final Version RESTART_FRAME = new Version(3, 12, 0);

    public static boolean isRunningAccurate(Version vmVersion) {
        return vmVersion != null && ACCURATE_RUNNING_FIELD.compareTo(vmVersion) <= 0;
    }

    public static boolean isRegExpBreakpointSupported(Version vmVersion) {
        return vmVersion != null && REG_EXP_BREAKPOINT.compareTo(vmVersion) <= 0;
    }

    public static boolean isFunctionScopeSupported(Version vmVersion) {
        return vmVersion != null && FUNCTION_SCOPE.compareTo(vmVersion) <= 0;
    }

    public static boolean isRestartFrameSupported(Version vmVersion) {
        return vmVersion != null && RESTART_FRAME.compareTo(vmVersion) <= 0;
    }
}

