/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;

public class RemoveMemberValuePairTest
extends AbstractAnnotationTest {
    @Override
    protected Annotation getAnnotation() {
        return null;
    }

    @Override
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"Calculator\")\n");
        classContents.append("public class Calculator {\n}");
        return classContents.toString();
    }

    @Override
    protected String getClassName() {
        return "Calculator.java";
    }

    @Override
    protected String getPackageName() {
        return "com.example";
    }

    public void testRemoveMemberValuePairFromAnnotation() {
        try {
            IType type = this.source.findPrimaryType();
            RemoveMemberValuePairTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)"WebService"));
            Annotation webService = AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
            RemoveMemberValuePairTest.assertNotNull((Object)webService);
            RemoveMemberValuePairTest.assertTrue((boolean)(webService instanceof NormalAnnotation));
            NormalAnnotation webServiceAnnotation = (NormalAnnotation)webService;
            RemoveMemberValuePairTest.assertTrue((webServiceAnnotation.values().size() == 1 ? 1 : 0) != 0);
            MemberValuePair nameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webServiceAnnotation, (String)"name");
            AnnotationUtils.removeMemberValuePair((NormalAnnotation)webServiceAnnotation, (MemberValuePair)nameValuePair);
            webServiceAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
            RemoveMemberValuePairTest.assertTrue((webServiceAnnotation.values().size() == 0 ? 1 : 0) != 0);
        }
        catch (CoreException ce) {
            RemoveMemberValuePairTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

