/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TableModelAdapter;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableModelAdapterTest {
    private Shell shell;
    private ModifiablePropertyValueModel<Manager> subjectHolder;

    private ColumnAdapter<Employee> buildColumnAdapter() {
        return new TableColumnAdapter();
    }

    private ModifiablePropertyValueModel<Employee> buildEmployeeHolder() {
        return new SimplePropertyValueModel();
    }

    private SimpleCollectionValueModel<Employee> buildEmployeeHolders() {
        return new SimpleCollectionValueModel();
    }

    private ListValueModel<Employee> buildEmployeeListHolder() {
        return new ListAspectAdapter<Manager, Employee>(this.subjectHolder, new String[]{"employees"}){

            protected ListIterator<Employee> listIterator_() {
                return ((Manager)((Object)this.subject)).employees();
            }

            protected int size_() {
                return ((Manager)((Object)this.subject)).employeesSize();
            }
        };
    }

    private ITableLabelProvider buildLabelProvider() {
        return new TableLabelProvider();
    }

    private TableModelAdapter.SelectionChangeListener<Employee> buildSelectionChangeListener(final Collection<Employee> employees) {
        return new TableModelAdapter.SelectionChangeListener<Employee>(){

            public void selectionChanged(TableModelAdapter.SelectionChangeEvent<Employee> e) {
                employees.clear();
                CollectionTools.addAll((Collection)employees, (Iterable)e.getSelection());
            }
        };
    }

    private ModifiablePropertyValueModel<Manager> buildSubjectHolder() {
        return new SimplePropertyValueModel();
    }

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell(Display.getCurrent());
        this.subjectHolder = this.buildSubjectHolder();
    }

    @After
    public void tearDown() throws Exception {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
        this.subjectHolder = null;
    }

    @Test
    public void testChanged() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        Assert.assertEquals((String)"The number of TableItems should be 3", (long)3L, (long)table.getItemCount());
        ArrayList<Employee> employees = new ArrayList<Employee>(3);
        employees.add(employee3);
        employees.add(employee2);
        employees.add(employee1);
        manager.changeEmployees(employees);
        Assert.assertEquals((String)"The number of TableItems should be 3", (long)3L, (long)table.getItemCount());
        this.testTableItemProperties(table, 0, expectedName3, expectedManager3, expectedTitle3);
        this.testTableItemProperties(table, 1, expectedName2, expectedManager2, expectedTitle2);
        this.testTableItemProperties(table, 2, expectedName1, expectedManager1, expectedTitle1);
    }

    @Test
    public void testCleared() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        Assert.assertEquals((String)"The number of TableItems should be 3", (long)3L, (long)table.getItemCount());
        manager.removeAllEmployees();
        Assert.assertEquals((String)"The list holder should have been cleared", (long)0L, (long)listHolder.size());
        Assert.assertEquals((String)"The Table should have been cleared", (long)0L, (long)table.getItemCount());
    }

    @Test
    public void testItemAdded() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName = "Dali";
        String expectedManager = "WTP";
        String expectedTitle = "plug-in";
        Employee employee = manager.addEmployee(expectedName, expectedTitle, expectedManager);
        Assert.assertNotNull((String)"The new Employee was not created", (Object)((Object)employee));
        int index = tableModel.indexOf(employee);
        Assert.assertEquals((String)"The new Employee was not added to the table model", (long)0L, (long)index);
        Assert.assertEquals((String)"The number of TableItem should be 1", (long)1L, (long)table.getItemCount());
        this.testTableItemProperties(table, index, expectedName, expectedManager, expectedTitle);
    }

    @Test
    public void testItemMoved() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        Assert.assertEquals((String)"The number of TableItem should be 3", (long)3L, (long)table.getItemCount());
        manager.moveEmployeeUp(employee2);
        int index1 = tableModel.indexOf(employee1);
        Assert.assertEquals((String)"The Employee 1 was not moved in the table model", (long)1L, (long)index1);
        int index2 = tableModel.indexOf(employee2);
        Assert.assertEquals((String)"The Employee 2 was not moved in the table model", (long)0L, (long)index2);
        int index3 = tableModel.indexOf(employee3);
        Assert.assertEquals((String)"The Employee 3 should not have been moved in the table model", (long)2L, (long)index3);
        this.testTableItemProperties(table, index1, expectedName1, expectedManager1, expectedTitle1);
        this.testTableItemProperties(table, index2, expectedName2, expectedManager2, expectedTitle2);
        this.testTableItemProperties(table, index3, expectedName3, expectedManager3, expectedTitle3);
        manager.moveEmployeeDown(employee1);
        index1 = tableModel.indexOf(employee1);
        Assert.assertEquals((String)"The Employee 1 should not have been moved in the table model", (long)2L, (long)index1);
        index2 = tableModel.indexOf(employee2);
        Assert.assertEquals((String)"The Employee 2 was not moved in the table model", (long)0L, (long)index2);
        index3 = tableModel.indexOf(employee3);
        Assert.assertEquals((String)"The Employee 3 was not moved in the table model", (long)1L, (long)index3);
        this.testTableItemProperties(table, index1, expectedName1, expectedManager1, expectedTitle1);
        this.testTableItemProperties(table, index2, expectedName2, expectedManager2, expectedTitle2);
        this.testTableItemProperties(table, index3, expectedName3, expectedManager3, expectedTitle3);
    }

    @Test
    public void testItemRemoved() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName = "Dali";
        String expectedManager = "WTP";
        String expectedTitle = "plug-in";
        Employee employee = manager.addEmployee(expectedName, expectedTitle, expectedManager);
        Assert.assertNotNull((String)"The new Employee was not created", (Object)((Object)employee));
        Assert.assertEquals((String)"The number of TableItem should be 1", (long)1L, (long)table.getItemCount());
        int index = tableModel.indexOf(employee);
        Assert.assertEquals((String)"The new Employee was not added to the table model", (long)0L, (long)index);
        this.testTableItemProperties(table, index, expectedName, expectedManager, expectedTitle);
        TableItem tableItem = table.getItem(index);
        Assert.assertNotNull((String)"No TableItem was found for the new Employee", (Object)tableItem);
        manager.removeEmployee(employee);
        index = tableModel.indexOf(employee);
        Assert.assertEquals((String)"The Employee was not removed from the table model", (long)-1L, (long)index);
        Assert.assertEquals((String)"The number of TableItem should be 0", (long)0L, (long)table.getItemCount());
    }

    @Test
    public void testItemReplaced() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        Employee employee1 = manager.addEmployee(expectedName1, expectedTitle1, expectedManager1);
        Assert.assertNotNull((String)"The new Employee was not created", (Object)((Object)employee1));
        int index1 = tableModel.indexOf(employee1);
        Assert.assertEquals((String)"The new Employee was not added to the table model", (long)0L, (long)index1);
        Assert.assertEquals((String)"The number of TableItem should be 1", (long)1L, (long)table.getItemCount());
        TableItem tableItem = table.getItem(index1);
        Assert.assertNotNull((String)"No TableItem was found for the new Employee", (Object)tableItem);
        this.testTableItemProperties(table, index1, expectedName1, expectedManager1, expectedTitle1);
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        manager.replace(employee1, employee2);
        int index2 = tableModel.indexOf(employee2);
        Assert.assertSame((String)("The Employee that got replaced should be at index " + index1), (Object)index1, (Object)index2);
        Assert.assertEquals((String)"The number of TableItem should be 1", (long)1L, (long)table.getItemCount());
        this.testTableItemProperties(table, index2, expectedName2, expectedManager2, expectedTitle2);
    }

    @Test
    public void testItemsAdded() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        Assert.assertEquals((String)"The number of TableItem should be 3", (long)3L, (long)table.getItemCount());
        int index = tableModel.indexOf(employee1);
        Assert.assertEquals((String)"The Employee 1 was not added to the table model", (long)0L, (long)index);
        index = tableModel.indexOf(employee2);
        Assert.assertEquals((String)"The Employee 2 was not added to the table model", (long)1L, (long)index);
        index = tableModel.indexOf(employee3);
        Assert.assertEquals((String)"The Employee 3 was not added to the table model", (long)2L, (long)index);
        this.testTableItemProperties(table, 0, expectedName1, expectedManager1, expectedTitle1);
        this.testTableItemProperties(table, 1, expectedName2, expectedManager2, expectedTitle2);
        this.testTableItemProperties(table, 2, expectedName3, expectedManager3, expectedTitle3);
    }

    @Test
    public void testItemsMoved() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        String expectedName4 = "Dali_4";
        String expectedManager4 = "WTP_4";
        String expectedTitle4 = "plug-in_4";
        String expectedName5 = "Dali_5";
        String expectedManager5 = "WTP_5";
        String expectedTitle5 = "plug-in_5";
        String expectedName6 = "Dali_6";
        String expectedManager6 = "WTP_6";
        String expectedTitle6 = "plug-in_6";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        Employee employee4 = new Employee(expectedName4, expectedTitle4, expectedManager4);
        Employee employee5 = new Employee(expectedName5, expectedTitle5, expectedManager5);
        Employee employee6 = new Employee(expectedName6, expectedTitle6, expectedManager6);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        manager.addEmployee(employee4);
        manager.addEmployee(employee5);
        manager.addEmployee(employee6);
        Assert.assertEquals((String)"The number of TableItem should be 6", (long)6L, (long)table.getItemCount());
        ArrayList<Employee> employees = new ArrayList<Employee>(3);
        employees.add(employee3);
        employees.add(employee4);
        employees.add(employee5);
        manager.moveEmployees(employees, 0);
        int index1 = tableModel.indexOf(employee1);
        int index2 = tableModel.indexOf(employee2);
        int index3 = tableModel.indexOf(employee3);
        int index4 = tableModel.indexOf(employee4);
        int index5 = tableModel.indexOf(employee5);
        int index6 = tableModel.indexOf(employee6);
        Assert.assertEquals((String)"The Employee 1 is not at the right index", (long)3L, (long)index1);
        Assert.assertEquals((String)"The Employee 2 is not at the right index", (long)4L, (long)index2);
        Assert.assertEquals((String)"The Employee 3 is not at the right index", (long)0L, (long)index3);
        Assert.assertEquals((String)"The Employee 4 is not at the right index", (long)1L, (long)index4);
        Assert.assertEquals((String)"The Employee 5 is not at the right index", (long)2L, (long)index5);
        Assert.assertEquals((String)"The Employee 6 is not at the right index", (long)5L, (long)index6);
        this.testTableItemProperties(table, index1, expectedName1, expectedManager1, expectedTitle1);
        this.testTableItemProperties(table, index2, expectedName2, expectedManager2, expectedTitle2);
        this.testTableItemProperties(table, index3, expectedName3, expectedManager3, expectedTitle3);
        this.testTableItemProperties(table, index4, expectedName4, expectedManager4, expectedTitle4);
        this.testTableItemProperties(table, index5, expectedName5, expectedManager5, expectedTitle5);
        this.testTableItemProperties(table, index6, expectedName6, expectedManager6, expectedTitle6);
        employees = new ArrayList(2);
        employees.add(employee1);
        employees.add(employee2);
        manager.moveEmployees(employees, 4);
        index1 = tableModel.indexOf(employee1);
        index2 = tableModel.indexOf(employee2);
        index3 = tableModel.indexOf(employee3);
        index4 = tableModel.indexOf(employee4);
        index5 = tableModel.indexOf(employee5);
        index6 = tableModel.indexOf(employee6);
        Assert.assertEquals((String)"The Employee 1 is not at the right index", (long)4L, (long)index1);
        Assert.assertEquals((String)"The Employee 2 is not at the right index", (long)5L, (long)index2);
        Assert.assertEquals((String)"The Employee 3 is not at the right index", (long)0L, (long)index3);
        Assert.assertEquals((String)"The Employee 4 is not at the right index", (long)1L, (long)index4);
        Assert.assertEquals((String)"The Employee 5 is not at the right index", (long)2L, (long)index5);
        Assert.assertEquals((String)"The Employee 6 is not at the right index", (long)3L, (long)index6);
        this.testTableItemProperties(table, index1, expectedName1, expectedManager1, expectedTitle1);
        this.testTableItemProperties(table, index2, expectedName2, expectedManager2, expectedTitle2);
        this.testTableItemProperties(table, index3, expectedName3, expectedManager3, expectedTitle3);
        this.testTableItemProperties(table, index4, expectedName4, expectedManager4, expectedTitle4);
        this.testTableItemProperties(table, index5, expectedName5, expectedManager5, expectedTitle5);
        this.testTableItemProperties(table, index6, expectedName6, expectedManager6, expectedTitle6);
    }

    @Test
    public void testItemsRemoved() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        Assert.assertEquals((String)"The number of TableItem should be 3", (long)3L, (long)table.getItemCount());
        int index = tableModel.indexOf(employee1);
        Assert.assertEquals((String)"The Employee 1 was not added to the table model", (long)0L, (long)index);
        index = tableModel.indexOf(employee2);
        Assert.assertEquals((String)"The Employee 2 was not added to the table model", (long)1L, (long)index);
        index = tableModel.indexOf(employee3);
        Assert.assertEquals((String)"The Employee 3 was not added to the table model", (long)2L, (long)index);
        ArrayList<Employee> employees = new ArrayList<Employee>(2);
        employees.add(employee1);
        employees.add(employee3);
        manager.removeEmployees(employees);
        Assert.assertEquals((String)"The number of TableItem should be 1", (long)1L, (long)table.getItemCount());
    }

    @Test
    public void testPropertyChanged() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        ModifiablePropertyValueModel<Employee> selectedItemHolder = this.buildEmployeeHolder();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, selectedItemHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName = "Dali";
        String expectedManager = "WTP";
        String expectedTitle = "plug-in";
        Employee employee = manager.addEmployee(expectedName, expectedTitle, expectedManager);
        Assert.assertNotNull((String)"The new Employee was not created", (Object)((Object)employee));
        int index = tableModel.indexOf(employee);
        Assert.assertEquals((String)"The new Employee was not added to the table model", (long)0L, (long)index);
        Assert.assertEquals((String)"The number of TableItem should be 1", (long)1L, (long)table.getItemCount());
        TableItem tableItem = table.getItem(index);
        Assert.assertNotNull((String)"No TableItem was found for the new Employee", (Object)tableItem);
        String actualName = tableItem.getText(0);
        Assert.assertEquals((String)"TableItem[NAME_COLUMN] was not set correctly", (Object)expectedName, (Object)actualName);
        expectedName = "Jpt";
        employee.setName(expectedName);
        actualName = tableItem.getText(0);
        Assert.assertEquals((String)"TableItem[NAME_COLUMN] was not set correctly", (Object)expectedName, (Object)actualName);
        String actualManager = tableItem.getText(2);
        Assert.assertEquals((String)"TableItem[MANAGER_COLUMN] was not set correctly", (Object)expectedManager, (Object)actualManager);
        expectedManager = "boss";
        employee.setManager(expectedManager);
        actualManager = tableItem.getText(2);
        Assert.assertEquals((String)"TableItem[MANAGER_COLUMN] was not set correctly", (Object)expectedManager, (Object)actualManager);
        String actualTitle = tableItem.getText(1);
        Assert.assertEquals((String)"TableItem[TITLE_COLUMN] was not set correctly", (Object)expectedTitle, (Object)actualTitle);
        expectedTitle = "EclipseLink";
        employee.setTitle(expectedTitle);
        actualTitle = tableItem.getText(1);
        Assert.assertEquals((String)"TableItem[TITLE_COLUMN] was not set correctly", (Object)expectedTitle, (Object)actualTitle);
    }

    @Test
    public void testSelectedItemsAddedRemoved() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        SimpleCollectionValueModel<Employee> selectedItemsHolder = this.buildEmployeeHolders();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, (CollectionValueModel<Employee>)selectedItemsHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        ArrayList<Employee> employees = new ArrayList<Employee>(2);
        employees.add(employee1);
        employees.add(employee3);
        selectedItemsHolder.addAll(employees);
        Collection<Employee> actualEmployees = tableModel.selectedItems();
        Assert.assertNotNull((String)"The collection of selected items can't be null", actualEmployees);
        Assert.assertEquals((String)"The count of selected items should be 2", (long)2L, (long)actualEmployees.size());
        actualEmployees.remove((Object)employee1);
        actualEmployees.remove((Object)employee3);
        Assert.assertTrue((String)"The selected items was not retrieved correctly", (boolean)actualEmployees.isEmpty());
        selectedItemsHolder.remove((Object)employee1);
        actualEmployees = tableModel.selectedItems();
        Assert.assertNotNull((String)"The collection of selected items can't be null", actualEmployees);
        Assert.assertEquals((String)"The count of selected items should be 1", (long)1L, (long)actualEmployees.size());
        actualEmployees.remove((Object)employee3);
        Assert.assertTrue((String)"The selected items was not retrieved correctly", (boolean)actualEmployees.isEmpty());
    }

    @Test
    public void testSelectedItemsCleared() {
        Table table = new Table((Composite)this.shell, 66306);
        ListValueModel<Employee> listHolder = this.buildEmployeeListHolder();
        SimpleCollectionValueModel<Employee> selectedItemsHolder = this.buildEmployeeHolders();
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(listHolder, (CollectionValueModel<Employee>)selectedItemsHolder, table, this.buildColumnAdapter(), this.buildLabelProvider());
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        ArrayList<Employee> employees = new ArrayList<Employee>(2);
        employees.add(employee1);
        employees.add(employee3);
        selectedItemsHolder.addAll(employees);
        Collection<Employee> actualEmployees = tableModel.selectedItems();
        Assert.assertNotNull((String)"The collection of selected items can't be null", actualEmployees);
        Assert.assertEquals((String)"The count of selected items should be 2", (long)2L, (long)actualEmployees.size());
        actualEmployees.remove((Object)employee1);
        actualEmployees.remove((Object)employee3);
        Assert.assertTrue((String)"The selected items was not retrieved correctly", (boolean)actualEmployees.isEmpty());
        selectedItemsHolder.clear();
        actualEmployees = tableModel.selectedItems();
        Assert.assertNotNull((String)"The collection of selected items can't be null", actualEmployees);
        Assert.assertEquals((String)"The count of selected items should be ", (long)0L, (long)actualEmployees.size());
    }

    @Test
    public void testSelectionChangeListener() {
        Table table = new Table((Composite)this.shell, 66306);
        Manager manager = new Manager();
        this.subjectHolder.setValue((Object)manager);
        TableModel tableModel = new TableModel(this.buildEmployeeListHolder(), this.buildEmployeeHolder(), table, this.buildColumnAdapter(), this.buildLabelProvider());
        ArrayList<Employee> employees = new ArrayList<Employee>();
        tableModel.addSelectionChangeListener(this.buildSelectionChangeListener(employees));
        String expectedName1 = "Dali_1";
        String expectedManager1 = "WTP_1";
        String expectedTitle1 = "plug-in_1";
        String expectedName2 = "Dali_2";
        String expectedManager2 = "WTP_2";
        String expectedTitle2 = "plug-in_2";
        String expectedName3 = "Dali_3";
        String expectedManager3 = "WTP_3";
        String expectedTitle3 = "plug-in_3";
        Employee employee1 = new Employee(expectedName1, expectedTitle1, expectedManager1);
        Employee employee2 = new Employee(expectedName2, expectedTitle2, expectedManager2);
        Employee employee3 = new Employee(expectedName3, expectedTitle3, expectedManager3);
        manager.addEmployee(employee1);
        manager.addEmployee(employee2);
        manager.addEmployee(employee3);
        int[] nArray = new int[2];
        nArray[1] = 2;
        table.setSelection(nArray);
        tableModel.tableSelectionChanged(null);
        Assert.assertNotNull((String)"The collection of selected items can't be null", employees);
        Assert.assertEquals((String)"The count of selected items should be 2", (long)2L, (long)employees.size());
        employees.remove((Object)employee1);
        employees.remove((Object)employee3);
        Assert.assertTrue((String)"The selected items was not retrieved correctly", (boolean)employees.isEmpty());
        employees.add(employee1);
        employees.add(employee3);
        table.deselectAll();
        tableModel.tableSelectionChanged(null);
        Assert.assertNotNull((String)"The collection of selected items can't be null", employees);
        Assert.assertEquals((String)"The count of selected items should be 0", (long)0L, (long)employees.size());
    }

    private void testTableItemProperties(Table table, int index, String expectedName, String expectedManager, String expectedTitle) {
        TableItem tableItem = table.getItem(index);
        Assert.assertNotNull((String)"No TableItem was found for the Employee", (Object)tableItem);
        String actualName = tableItem.getText(0);
        Assert.assertEquals((String)"TableItem[NAME_COLUMN] was not set correctly", (Object)expectedName, (Object)actualName);
        String actualTitle = tableItem.getText(1);
        Assert.assertEquals((String)"TableItem[TITLE_COLUMN] was not set correctly", (Object)expectedTitle, (Object)actualTitle);
        String actualManager = tableItem.getText(2);
        Assert.assertEquals((String)"TableItem[MANAGER_COLUMN] was not set correctly", (Object)expectedManager, (Object)actualManager);
    }

    private class Employee
    extends AbstractModel {
        private String manager;
        private String name;
        private String title;
        static final String MANAGER_PROPERTY = "manager";
        static final String NAME_PROPERTY = "name";
        static final String TITLE_PROPERTY = "title";

        Employee(String name, String title, String manager) {
            this.name = name;
            this.title = title;
            this.manager = manager;
        }

        String getManager() {
            return this.manager;
        }

        String getName() {
            return this.name;
        }

        String getTitle() {
            return this.title;
        }

        void setManager(String manager) {
            String oldManager = this.manager;
            this.manager = manager;
            this.firePropertyChanged(MANAGER_PROPERTY, oldManager, manager);
        }

        void setName(String name) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, oldName, name);
        }

        void setTitle(String title) {
            String oldTitle = this.title;
            this.title = title;
            this.firePropertyChanged(TITLE_PROPERTY, oldTitle, title);
        }
    }

    private class Manager
    extends AbstractModel {
        private List<Employee> employees = new ArrayList<Employee>();
        static final String EMPLOYEES_LIST = "employees";

        Manager() {
        }

        Employee addEmployee(Employee employee) {
            this.addItemToList((Object)employee, this.employees, EMPLOYEES_LIST);
            return employee;
        }

        Employee addEmployee(String name, String title, String manager) {
            Employee employee = new Employee(name, title, manager);
            return this.addEmployee(employee);
        }

        void changeEmployees(List<Employee> newEmployees) {
            this.synchronizeList(newEmployees, this.employees, EMPLOYEES_LIST);
        }

        ListIterator<Employee> employees() {
            return IteratorTools.clone(this.employees);
        }

        int employeesSize() {
            return this.employees.size();
        }

        void moveEmployeeDown(Employee employee) {
            int index = this.employees.indexOf((Object)employee);
            this.moveItemInList(index + 1, index, this.employees, EMPLOYEES_LIST);
        }

        void moveEmployees(Collection<Employee> employees, int targetIndex) {
            int sourceIndex = Integer.MAX_VALUE;
            for (Employee employee : employees) {
                sourceIndex = Math.min(sourceIndex, this.employees.indexOf((Object)employee));
            }
            this.moveItemsInList(targetIndex, sourceIndex, employees.size(), this.employees, EMPLOYEES_LIST);
        }

        void moveEmployeeUp(Employee employee) {
            int index = this.employees.indexOf((Object)employee);
            this.moveItemInList(index - 1, index, this.employees, EMPLOYEES_LIST);
        }

        void removeAllEmployees() {
            this.clearList(this.employees, EMPLOYEES_LIST);
        }

        void removeEmployee(Employee employee) {
            this.removeItemFromList((Object)employee, this.employees, EMPLOYEES_LIST);
        }

        void removeEmployees(Collection<Employee> employees) {
            this.removeItemsFromList(employees.iterator(), this.employees, EMPLOYEES_LIST);
        }

        void replace(Employee oldEmployee, Employee newEmployee) {
            this.replaceItemInList((Object)oldEmployee, (Object)newEmployee, this.employees, EMPLOYEES_LIST);
        }
    }

    private class TableColumnAdapter
    implements ColumnAdapter<Employee> {
        static final int COLUMN_COUNT = 3;
        static final int MANAGER_COLUMN = 2;
        static final int NAME_COLUMN = 0;
        static final int TITLE_COLUMN = 1;

        private TableColumnAdapter() {
        }

        private ModifiablePropertyValueModel<String> buildManagerHolder(Employee subject) {
            return new PropertyAspectAdapter<Employee, String>("manager", subject){

                protected String buildValue_() {
                    return ((Employee)((Object)this.subject)).getManager();
                }

                protected void setValue_(String value) {
                    ((Employee)((Object)this.subject)).setManager(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildNameHolder(Employee subject) {
            return new PropertyAspectAdapter<Employee, String>("name", subject){

                protected String buildValue_() {
                    return ((Employee)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((Employee)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildTitleHolder(Employee subject) {
            return new PropertyAspectAdapter<Employee, String>("title", subject){

                protected String buildValue_() {
                    return ((Employee)((Object)this.subject)).getTitle();
                }

                protected void setValue_(String value) {
                    ((Employee)((Object)this.subject)).setTitle(value);
                }
            };
        }

        public ModifiablePropertyValueModel<?>[] cellModels(Employee subject) {
            ModifiablePropertyValueModel[] holders = new ModifiablePropertyValueModel[]{this.buildNameHolder(subject), this.buildTitleHolder(subject), this.buildManagerHolder(subject)};
            return holders;
        }

        public int columnCount() {
            return 3;
        }

        public String columnName(int columnIndex) {
            return String.valueOf(columnIndex);
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Employee employee = (Employee)((Object)element);
            if (columnIndex == 0) {
                return employee.getName();
            }
            if (columnIndex == 1) {
                return employee.getTitle();
            }
            return employee.getManager();
        }
    }

    private class TableModel
    extends TableModelAdapter<Employee> {
        TableModel(ListValueModel<Employee> listHolder, CollectionValueModel<Employee> selectedItemsHolder, Table table, ColumnAdapter<Employee> columnAdapter, ITableLabelProvider labelProvider) {
            super(listHolder, selectedItemsHolder, table, columnAdapter, labelProvider);
        }

        TableModel(ListValueModel<Employee> listHolder, ModifiablePropertyValueModel<Employee> selectedItemHolder, Table table, ColumnAdapter<Employee> columnAdapter, ITableLabelProvider labelProvider) {
            super(listHolder, (CollectionValueModel)new PropertyCollectionValueModelAdapter(selectedItemHolder), table, columnAdapter, labelProvider);
        }

        protected int indexOf(Employee item) {
            return super.indexOf((Object)item);
        }

        protected Collection<Employee> selectedItems() {
            return super.selectedItems();
        }

        protected void tableSelectionChanged(SelectionEvent event) {
            super.tableSelectionChanged(event);
        }
    }
}

